% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotZscore.R
\name{plotZscore}
\alias{plotZscore}
\title{Plots of z scores}
\usage{
plotZscore(
  data,
  cell_range = NULL,
  segment_size = 2,
  reference_lines = c(-1.65, 1.65)
)
}
\arguments{
\item{data}{Data frame. A data frame of cell id and features.}

\item{cell_range}{Vector. A numeric vector of cell id range for which the plot should be displayed. 
Default is NULL, which plots all the cells.}

\item{segment_size}{Integer.  A numeric value to indicate the size of the bars in the plot. 
Default is 2.}

\item{reference_lines}{Vector. A numeric vector of confidence interval values for the 
reference lines in the plot. Default is c(-1.65, 1.65).}
}
\value{
A grid of plots of z score against cell id of teh given features.
}
\description{
This is the main function to plot the z scores against cell ids.
}
\examples{
data("EuStockMarkets")
dataset <- data.frame(t = as.numeric(time(EuStockMarkets)),
                     DAX = EuStockMarkets[, "DAX"],
                     SMI = EuStockMarkets[, "SMI"],
                     CAC = EuStockMarkets[, "CAC"],
                     FTSE = EuStockMarkets[, "FTSE"])
rownames(EuStockMarkets) <- dataset$t
hvt.results<- trainHVT(dataset[-1],n_cells = 60, depth = 1, quant.err = 0.1,
                      distance_metric = "L1_Norm", error_metric = "max",
                      normalize = TRUE,quant_method = "kmeans")
col_names <- c("Cell.ID","DAX","SMI","CAC","FTSE")
data <- dplyr::arrange(dplyr::select(hvt.results[[3]][["summary"]],col_names),Cell.ID)
data <- round(data, 2)
plotZscore(data)
}
\author{
Vishwavani <vishwavani@mu-sigma.com>
}
\keyword{EDA}
