% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MI.R
\name{HeckmanEM.infomat}
\alias{HeckmanEM.infomat}
\title{Standard error estimation for the Heckman Selection model by the Information Matrix}
\usage{
HeckmanEM.infomat(obj)
}
\arguments{
\item{obj}{An object of the class HeckmanEM.}
}
\value{
The estimated standard errors for the parameters of the fitted model.
}
\description{
`HeckmanEM.infomat()` estimates the standard errors for the parameters for the fitted Heckman selection model.
}
\examples{
\donttest{
n <- 100
family <- "T"
nu <- 4
rho <- .6
cens <- .25

set.seed(20200527)
w <- cbind(1,runif(n,-1,1),rnorm(n))
x <- cbind(w[,1:2])
c <- qt(cens, df=nu)

sigma2 <- 1

beta <- c(1,0.5)
gamma <- c(1,0.3,-.5)
gamma[1] <- -c*sqrt(sigma2)

set.seed(1)
datas <- rHeckman(x,w,beta,gamma,sigma2,rho,nu,family=family)
y <- datas$y
cc <- datas$cc

res <- HeckmanEM(y, x, w, cc, nu = 4, family = "Normal", error = 1e-05, iter.max = 500,
                 im = FALSE, criteria = TRUE)
im <- HeckmanEM.infomat(res)
}
}
