% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cArrows.R
\name{cArrows}
\alias{cArrows}
\title{Draw curved lines with arrowhead}
\usage{
cArrows(
  x1,
  y1,
  x2,
  y2,
  code = 2,
  size = 1,
  width = 1.2/4/cin,
  open = TRUE,
  sh.adj = 0.1,
  sh.lwd = 1,
  sh.col = if (is.R()) par("fg") else 1,
  sh.lty = 1,
  h.col = sh.col,
  h.col.bo = sh.col,
  h.lwd = sh.lwd,
  h.lty = sh.lty,
  curved = FALSE,
  beautiful.arrow = 2/3
)
}
\arguments{
\item{x1}{coordinates of points from which to draw.}

\item{y1}{coordinates of points from which to draw.}

\item{x2}{coordinates of points to which to draw.}

\item{y2}{coordinates of points to which to draw.}

\item{code}{integer code (1, 2, or 3), determining kind of arrows to be drawn.}

\item{size}{size of the arrowhead.}

\item{width}{width of the arrowhead.}

\item{open}{shape of the arrowhead.}

\item{sh.adj}{Shift the beginning of the line.}

\item{sh.lwd}{width of the line.}

\item{sh.col}{color of the line.}

\item{sh.lty}{type of line.}

\item{h.col}{color of the arrowhead.}

\item{h.col.bo}{color of the arrowhead border.}

\item{h.lwd}{width of the arrowhead.}

\item{h.lty}{type of line for the arrowhead.}

\item{curved}{0 is a straigth line, positive of negative value make the line curved.}

\item{beautiful.arrow}{if open is false, make the arrowhead more beautiful.}
}
\value{
A list wit lab.x and lab.y being the position where to draw label
}
\description{
Draw a curved line with arrowhead.
}
\details{
cArrows draws curved lines with arrowhead
}
\examples{
plot(c(1, 10), c(1, 10), type="n", bty="n")
cArrows(x1=2, y1=2, x2=6, y2=6, curved=1)
cArrows(x1=2, y1=2, x2=6, y2=6, curved=0)
cArrows(x1=2, y1=2, x2=6, y2=6, curved=1, sh.adj=1)
cArrows(x1=2, y1=2, x2=6, y2=6, curved=-1, open=FALSE)
cArrows(x1=9, y1=2, x2=6, y2=6, curved=-1, open=FALSE, sh.col="red")
cArrows(x1=9, y1=9, x2=6, y2=6, curved=-1, open=FALSE, h.col="red")
cArrows(x1=2, y1=9, x2=6, y2=6, curved=1, open=FALSE, h.col="red", h.col.bo="red")
}
\author{
Modified from iGraph
}
