% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HERC_Portfolio.R
\name{HERC_Portfolio}
\alias{HERC_Portfolio}
\title{Hierarchical Equal Risk Contribution}
\usage{
HERC_Portfolio(covar, linkage = "ward", graph = FALSE, clusters = NULL)
}
\arguments{
\item{covar}{Covariance matrix of returns. The covariance matrix will be transformed into correlation matrix and then into a distance matrix.}

\item{linkage}{Linkage method used in the hierarchical clustering. Allowed options are "single", "complete", "average" or "ward". Default option is "ward".}

\item{graph}{To plot de dendrogram set this value to TRUE. By default this value is equal to FALSE.}

\item{clusters}{Numbers of clusters. If NULL (default), the gap index is applied.}
}
\value{
portfolio weights.
}
\description{
Performs the Hierarchical Equal Risk Contribution portfolio strategy proposed by Raffinot (2018). Several linkage methods for the hierarchical clustering can be used, by default the "ward" linkage is used. This function uses the variance as risk measure. The number of clusters is selected using the Gap index of Tibshirani et al. (2001). The implemenation follows Sjostrand and Nina (2020).
}
\examples{
covar <- cov(daily_returns)
HERC_Portfolio(covar)
}
\references{
Raffinot, Thomas. "The hierarchical equal risk contribution portfolio." Available at SSRN 3237540 (2018).

Tibshirani, Robert, Guenther Walther, and Trevor Hastie. "Estimating the number of clusters in a data set via the gap statistic." Journal of the Royal Statistical Society: Series B (Statistical Methodology) 63.2 (2001): 411-423.
}
\seealso{
\code{HRP_Portfolio}, \code{HCAA_Portfolio} and \code{DHRP_Portfolio}
}
\author{
Carlos Trucios and Moon Jun Kwon
}
\keyword{HERC}
