% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/HighDimOut.R
\name{Func.FBOD}
\alias{Func.FBOD}
\title{Feature-bagging outlier detection (FBOD) algorithm}
\usage{
Func.FBOD(data, iter, k.nn)
}
\arguments{
\item{data}{is the data frame containing the observations. Each row represents an observation and each variable is stored in one column.}

\item{iter}{is the iteration used.}

\item{k.nn}{is the value used for calculating the LOF score}
}
\value{
The function returns a vector containing the FBOD outlier scores for each observation
}
\description{
This function performs feature-bagging based outlier detection algorithm
The implemented method is based on the work of "Lazarevic, A., Kumar, V., Feature bagging for outlier detection, 2005"
This method can be regarded as an ensemble method, which based on the results of local outlier factor (LOF).
During each iteration, a random subset of variables, whose size is randomly chosen between d/2 to d (where d is the dimensionality of the input data), is selected.
The LOF method is applied to calculate the LOF scores based on the selected data subset.
The final score of FBOD is the cumulative sum of each iteration.
}
\examples{
library(ggplot2)
res.FBOD <- Func.FBOD(data = TestData[,1:2], iter=10, k.nn=5)
data.temp <- TestData[,1:2]
data.temp$Ind <- NA
data.temp[order(res.FBOD, decreasing = TRUE)[1:10],"Ind"] <- "Outlier"
data.temp[is.na(data.temp$Ind),"Ind"] <- "Inlier"
data.temp$Ind <- factor(data.temp$Ind)
ggplot(data = data.temp) + geom_point(aes(x = x, y = y, color=Ind, shape=Ind))
}

