% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_MatH.R
\docType{methods}
\name{plot-MatH}
\alias{plot-MatH}
\alias{plot,MatH-method}
\title{Method plot for a matrix  of histograms}
\usage{
\S4method{plot}{MatH}(x, y = "missing", type = "HISTO", border = "black", angL = 330)
}
\arguments{
\item{x}{a \code{distributionH} object}

\item{y}{not used in this implementation}

\item{type}{(optional) a string describing the type of plot, default="HISTO".\cr
Other allowed types are \cr
"DENS"=a density approximation, \cr
"BOXPLOT"=l boxplot}

\item{border}{(optional) a string the color of the border of the plot, default="black".}

\item{angL}{(optional) angle of labels of rows (DEFAULT=330).}
}
\description{
An overloading plot function for a \code{MatH} object. The method returns a graphical representation
of the matrix of histograms.
}
\examples{
plot(BLOOD) # plots BLOOD dataset
\dontrun{
plot(BLOOD, type = "HISTO", border = "blue") # plots a matrix of histograms
plot(BLOOD, type = "DENS", border = "blue") # plots a matrix of densities
plot(BLOOD, type = "BOXPLOT") # plots a  boxplots
}
}
