% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMarkovOrd.r
\name{intMarkovOrd}
\alias{intMarkovOrd}
\title{Compute Parameters for Proportional Odds Markov Model}
\usage{
intMarkovOrd(
  y,
  times,
  initial,
  absorb = NULL,
  intercepts,
  extra = NULL,
  g,
  target,
  t,
  ftarget = NULL,
  onlycrit = FALSE,
  constraints = NULL,
  printsop = FALSE,
  ...
)
}
\arguments{
\item{y}{vector of possible y values in order (numeric, character, factor)}

\item{times}{vector of measurement times}

\item{initial}{initial value of \code{y} (baseline state; numeric, character, or factor matching \code{y}).  If length 1 this value is used for all subjects, otherwise it is a vector of length \code{n}.}

\item{absorb}{vector of absorbing states, a subset of \code{y} (numeric, character, or factor matching \code{y}).  The default is no absorbing states.  Observations are truncated when an absorbing state is simulated.}

\item{intercepts}{vector of initial guesses for the intercepts}

\item{extra}{an optional vector of intial guesses for other parameters passed to \code{g} such as regression coefficients for previous states and for general time trends.  Name the elements of \code{extra} for more informative output.}

\item{g}{a user-specified function of three or more arguments which in order are \code{yprev} - the value of \code{y} at the previous time, the current time \code{t}, the \code{gap} between the previous time and the current time, an optional (usually named) covariate vector \code{X}, and optional arguments such as a regression coefficient value to simulate from.  The function needs to allow \code{yprev} to be a vector and \code{yprev} must not include any absorbing states.  The \code{g} function returns the linear predictor for the proportional odds model aside from \code{intercepts}.  The returned value must be a matrix with row names taken from \code{yprev}.  If the model is a proportional odds model, the returned value must be one column.  If it is a partial proportional odds model, the value must have one column for each distinct value of the response variable Y after the first one, with the levels of Y used as optional column names.  So columns correspond to \code{intercepts}. The different columns are used for \code{y}-specific contributions to the linear predictor (aside from \code{intercepts}) for a partial or constrained partial proportional odds model.  Parameters for partial proportional odds effects may be included in the ... arguments.}

\item{target}{vector of target state occupancy probabilities at time \code{t}.  If \code{extra} is specified, \code{target} must be a matrix where row names are character versions of \code{t} and columns represent occupancy probabilities corresponding to values of \code{y} at the time given in the row.}

\item{t}{target times.  Can have more than one element only if \code{extra} is given.}

\item{ftarget}{an optional function defining constraints that relate to transition probabilities.  The function returns a penalty which is a sum of absolute differences in probabilities from target probabilities over possibly multiple targets.  The \code{ftarget} function must have two arguments: \code{intercepts} and \code{extra}.}

\item{onlycrit}{set to \code{TRUE} to only return the achieved objective criterion and not print anything}

\item{constraints}{a function of two arguments: the vector of current intercept values and the vector of \code{extra} parameters, returning \code{TRUE} if that vector meets the constrains and \code{FALSE} otherwise}

\item{printsop}{set to \code{TRUE} to print solved-for state occupancy probabilities for groups 1 and 2}

\item{...}{optional arguments to pass to \code{\link[stats:nlm]{stats::nlm()}}.  If this is specified, the arguments that \code{intMarkovOrd} normally sends to \code{nlm} are not used.}
}
\value{
list containing two vectors named \code{intercepts} and \code{extra} unless \code{oncrit=TRUE} in which case the best achieved sum of absolute errors is returned
}
\description{
Given a vector \code{intercepts} of initial guesses at the intercepts in a Markov proportional odds model, and a vector \code{extra} if there are other parameters, solves for the \code{intercepts} and \code{extra} vectors that yields a set of occupancy probabilities at time \code{t} that equal, as closely as possible, a vector of target values.
}
\seealso{
\url{https://hbiostat.org/R/Hmisc/markov/}
}
\author{
Frank Harrell
}
