% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POR_calc_lp3_quantile.R
\name{POR_calc_lp3_quantile}
\alias{POR_calc_lp3_quantile}
\title{Calculate quantile from fitted log-Pearson type III distribution}
\usage{
POR_calc_lp3_quantile(annual_min, p)
}
\arguments{
\item{annual_min}{'numeric' vector. Vector of minimum annual n-day mean flows.}

\item{p}{'numeric' value of exceedance probabilities. Quantile of fitted distribution that is
returned (\code{p=0.1} for 10-year return period, \code{p=0.5} for 2-year return period)}
}
\value{
Specified quantile from the fitted log-Pearson type 3 distribution.
}
\description{
Calculate the specified flow quantile from a fitted log-Pearson type III
distribution from a time series of n-day low flows.
}
\details{
\code{POR_calc_lp3_quantile} fits an log-Pearson type III distribution to a series of annual n-day
flows and returns the quantile of a user-specified probability using \code{\link{calc_qlpearsonIII}}. This
represents a theoretical return period for than n-day flow.
}
\examples{
POR_calc_lp3_quantile(annual_min = example_annual$low_q1, p = 0.1)

}
\references{
Asquith, W.H., Kiang, J.E., and Cohn, T.A., 2017, Application of at-site peak-streamflow
frequency analyses for very low annual exceedance probabilities: U.S. Geological Survey
Scientific Investigation Report 2017–5038, 93 p.
[Also available at https://doi.org/10.3133/sir20175038.]
}
\seealso{
\code{\link{calc_qlpearsonIII}}
}
\keyword{annual-statistics}
\keyword{period-of-record}
