% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorRegex.R
\name{factorRegex}
\alias{factorRegex}
\title{Produce Regular Expressions for Extracting Factor Names and Levels}
\usage{
factorRegex(fit)
}
\arguments{
\item{fit}{a model object}
}
\description{
A utility function to produce a regular expression that can
  separate factor names and factor levels in the \code{broom::tidy()$term}
  output.  At some point, this may have to become a method to accomodate
  different model types, but I haven't run into that problem yet.
}
\examples{
data(PE, package = "HydeNet")
g6 <- glm(treat ~ d.dimer + angio, data=PE, family="binomial")
HydeNet:::factorRegex(g6)

}
\author{
Jarrod Dalton and Benjamin Nutter
}

