% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyramid.R
\name{age_pyramid.population}
\alias{age_pyramid.population}
\title{Age pyramid from a population at a given time.}
\usage{
\method{age_pyramid}{population}(object, time = 0, ages = c(0:110, Inf), ...)
}
\arguments{
\item{object}{Object of \code{\link{population}} class representing a population.}

\item{time}{The age pyramid is computed at instant \code{time}. Must be a numeric greater than or equal to 0.}

\item{ages}{\emph{(Optional)} A numeric vector of distinct positive values composing age groups. Must be in increasing order.}

\item{...}{Additional parameters}
}
\value{
An object of class \code{\link{pyramid}} containing the age pyramid of the given population at instant \code{time}.
}
\description{
Reduce a population containing all individuals (with some characteristics) to an age-groups data frame (preserving characteristics). The function computes the number of individuals at \code{time} in each age group \code{[ages[i],ages[i+1][}, for \code{i} in \code{\{1,...,N-1\}}.
}
\examples{
age_pyramid(population(EW_pop_14$sample), time = 0)

age_pyramid(population(EW_popIMD_14$sample), time = 0, ages = seq(0, 120, by=2))

}
\seealso{
\code{\link{age_pyramids.population}}
}
