% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{StrelkaSBSVCFFilesToCatalog}
\alias{StrelkaSBSVCFFilesToCatalog}
\title{Create SBS and DBS catalogs from Strelka SBS VCF files.}
\usage{
StrelkaSBSVCFFilesToCatalog(files, ref.genome, trans.ranges = NULL,
  region = "unknown")
}
\arguments{
\item{files}{Character vector of file paths to the Strelka SBS VCF files.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{a \code{\link[data.table]{data.table}} which contains
transcript range and strand information. Please refer to
\code{\link{TranscriptRanges}} for more details.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}
}
\value{
A list of 3 SBS catalogs (one each for 96, 192, and 1536) and 3 DBS
  catalogs (one each for 78, 136, and 144). If trans.ranges = NULL, SBS 192
  and DBS 144 catalog will not be generated. Each catalog has attributes
  added. See \code{\link{as.catalog}} for more details.
}
\description{
Create 3 SBS catalogs (96, 192, 1536) and 3 DBS catalogs (78, 136, 144)
from the Strelka SBS VCFs specified by \code{files}
}
\details{
This function calls \code{\link{VCFsToSBSCatalogs}} and
\code{\link{VCFsToDBSCatalogs}}.
}
\note{
SBS 192 and DBS 144 catalog only contains mutations in transcribed regions.
}
\examples{
file <- c(system.file("extdata",
                      "Strelka.SBS.GRCh37.vcf",
                      package = "ICAMS"))
catalogs <- StrelkaSBSVCFFilesToCatalog(file, ref.genome = "hg19",
                                        trans.ranges = trans.ranges.GRCh37,
                                        region = "genome")
}
