% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICABOD_help_page.R
\docType{package}
\name{ICAOD}
\alias{ICAOD}
\title{ICAOD: Finding Optimal Designs for Nonlinear Models Using Imperialist Competitive Algorithm}
\description{
Different functions are available to find optimal designs for linear and nonlinear models using the imperialist competitive algorithm (ICA).
Because the optimality criteria for linear and nonlinear models depend on the unknown parameters,
one should choose on of the following method to deal with the parameter-dependency based on the available information for the unknown parameters:
\itemize{
 \item{\code{\link{locally}}: }{finds locally optimal designs. A vector of initial estimates or guess is available for the vector of model parameters from a pilot or similar study.}
 \item{\code{\link{bayes}}: }{finds Bayesian optimal designs. A continuous prior is available for the vector of unknown model parameters.}
 \item{\code{\link{robust}}: }{finds robust or optimum-in-average designs. It is similar to \code{\link{bayes}}, but uses a discrete prior.}
 \item{\code{\link{minimax}}: }{finds minimax and standardized maximin optimal designs. Each of the unknown  parameters belongs to a user-specified interval. The purpose is to find a design that protects the user against the worst scenario over the parameter space.
 Standardized designs should be used when locally optimal design of the model of interest has an analytical solution.}
}

 Some functions are also available to find optimal designs for special applications:
\itemize{
 \item{\code{\link{multiple}}: }{finds locally multiple objective optimal designs for the 4-parameter Hill model with application in dose-response stuides. It uses the same strategy as  \code{locally} to deal with the unknown model parameters.}
 \item{\code{\link{bayescomp}}: }{finds a design that  meets the dual goal of the parameter estimation and
  increasing the probability of a particular outcome in a binary response  model.  It uses the same strategy as the function \code{bayes} to deal with the unknown mode parameters and applicable in medicine studies.}
}
}
\details{
The functions \code{\link{locally}} and \code{\link{robust}} are very easy to be applied and
they are usually fast. The speed of the functions \code{\link{bayes}} and \code{\link{minimax}}
considerably depends on the value of the tuning parameters.

The following functions may also be used  to verify the optimality of an output design for each of the above criterion:
\itemize{
\item{\code{\link{senslocally}}}
\item{\code{\link{sensrobust}}}
\item{\code{\link{sensbayes}}}
\item{\code{\link{sensminimax}}}
 \item{\code{\link{sensmultiple}}}
 \item{\code{\link{sensbayescomp}}}
}
For more details see Masoudi et al. (2017, 2019).
}
\references{
Masoudi E, Holling H, Wong WK (2017). Application of Imperialist Competitive Algorithm to Find Minimax and Standardized Maximin Optimal Designs. Computational Statistics and Data Analysis, 113, 330-345. <doi:10.1016/j.csda.2016.06.014> \cr
Masoudi E, Holling H, Duarte BP, Wong Wk (2019). Metaheuristic Adaptive Cubature Based Algorithm to Find Bayesian Optimal Designs for Nonlinear Models. Journal of Computational and Graphical Statistics. <doi:10.1080/10618600.2019.1601097>
}
