% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-UserMinimaxFunctions.R
\name{sens.minimax.control}
\alias{sens.minimax.control}
\title{Returns Control Parameters for Verifying General Equivalence Theorem For Minimax Optimal Designs}
\usage{
sens.minimax.control(n_seg = 6, merge_tol = 0.005)
}
\arguments{
\item{n_seg}{For a given design, the number of starting points in the local search to find all the local maxima of the minimax criterion over the parameter space is equal to \code{(n_seg + 1)^p}. Defaults to \code{6}.
Please increase its value when the parameter space is large. It is also applicable for standardized maximin designs. See 'Details' of \link{sens.minimax.control}.}

\item{merge_tol}{Merging tolerance. It is used  to  specify the elements of the answering set
by choosing only the local maxima (found by the local search) that are nearer to
the global maximum.  See 'Details' of \link{sens.minimax.control}. Defaults to \code{0.005}.
We advise to not change its default value because it has been successfully tested on many optimal design problems.}
}
\value{
A list of control parameters for verifying the general equivalence
 theorem for minimax and standardized maximin optimal designs.
}
\description{
This function returns a list of control parameters that are used to find
the ``answering set'' for minimax and
standardized maximin designs.
 The answering set is required to  obtain the sensitivity (derivative) function in order to verify the optimality of
 a given design.
}
\details{
Given a design, an ``answering set'' is a subset of all the local optima
  of the optimality criterion over the parameter space.
Answering set is used to obtain the sensitivity function
of a minimax or standardized maximin criterion.
   Therefore, an invalid  answering set may result in a false
  sensitivity plot and ELB.
 Unfortunately, there is no theoretical rule on how to choose the number of elements of
  the answering set; and they  have to be found by trial and error.
 Given a design, the answering set for a minimax criterion is obtained as follows:
 \itemize{
 \item{Step 1: }{Find all the local maxima of the optimality criterion (minimax)  over the parameter space.
  For this purpose,  the parameter space is divided into \code{(n_seg + 1)^p} segments,
   where p is the number of unknown model parameters.
   Then, each boundary point of the resulted segments (intervals) is assigned to the argument
   \code{par} of the function \code{optim} in order to start a local search
    using the \code{"L-BFGS-B"} method.}
 \item{Step 2: }{Pick the ones nearest to the global minimum subject to a merging tolerance
  \code{merge_tol} (default \code{0.005}).}
}
Obviously, the answering set is a subset of all the local maxima over the parameter space (or local minima in case of standardized maximin criteria)
Therefore, it is very important to be able to find all the local maxima to create the true answering set with no missing elements.
 Otherwise, even when the design is optimal, the sensitivity (derivative) plot may not reveal its optimality.

   Note that the minimax criterion (or standardized maximin criterion)
   is a multimodel function especially near the optimal design and
   this makes the job of finding all the locall maxima (minima) over the
   parameter space very complicated.
}
\examples{
sens.minimax.control()
sens.minimax.control(n_seg = 4)
}
