% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICS_S3.R
\name{coef.ICS-S3}
\alias{coef.ICS-S3}
\alias{coef.ICS}
\title{To extract the Coefficient Matrix of the ICS Transformation}
\usage{
\method{coef}{ICS}(object, select = NULL, drop = FALSE, index = NULL, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{"ICS"} containing
results from an ICS transformation.}

\item{select}{an integer, character, or logical vector specifying for which
components to extract the coefficients, or \code{NULL} to extract the
coefficients for all components.}

\item{drop}{a logical indicating whether to return a vector rather than a
matrix in case coefficients are extracted for a single component (default
to \code{FALSE}).}

\item{index}{an integer vector specifying for which components to extract
the coefficients, or \code{NULL} to extract coefficients for all components.
Note that \code{index} is deprecated and may be removed in the future, use
\code{select} instead.}

\item{\dots}{additional arguments are ignored.}
}
\value{
A numeric matrix or vector containing the coefficients for the
requested components.
}
\description{
Extracts the coefficient matrix of a linear transformation to an invariant
coordinate system. Each row of the matrix contains the coefficients of the
transformation to the corresponding component.
}
\examples{
data("iris")
X <- iris[,-5]
out <- ICS(X)
coef(out)
coef(out, select = c(1,4))
coef(out, select = 1, drop = FALSE)

}
\seealso{
\code{\link{ICS}()}

\code{\link{gen_kurtosis}()}, \code{\link{components}()},
\code{\link[=fitted.ICS]{fitted}()}, and \code{\link[=plot.ICS]{plot}()}
methods
}
\author{
Andreas Alfons and Aurore Archimbaud
}
