% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_IC_data.R
\name{gen_IC_data}
\alias{gen_IC_data}
\title{gen_IC_data.R}
\usage{
gen_IC_data(bhFunInv, obsTimes, windowHalf, etaVec, mod = "PH", probMiss = 0.1)
}
\arguments{
\item{bhFunInv}{A function, the inverse of the baseline hazard function.}

\item{obsTimes}{Vector of the intended observation times.}

\item{windowHalf}{The amount of time before or after the intended obsTimes that a visit might take place.}

\item{etaVec}{n*1 linear predictor in either the proportional odds or proportional hzards model.}

\item{mod}{Either "PH" to generate under PH model or "PO" to generate under PO model.}

\item{probMiss}{The probability of missing any given visit.}
}
\value{
A list with the elements:
\item{obs_ind}{n*1 vector of whether the event was observed before last follow-up.}
\item{tpos_ind}{n*1 vector of whether the event was observed after follow-up started (t>0).}
\item{tVec}{Fisher information matrix for the fitted coefficients.}
\item{leftTimes}{n*1 vector of left side of interval times.}
\item{rightTimes}{n*1 vector of right side of interval times.}
\item{tVec}{n*1 vector of exact event times.}
}
\description{
Generate interval-censored data under the proportional odds/PH model given a baseline hazard function and
some information about observation times.
}
\examples{
set.seed(0)
xMat <- matrix(data=rnorm(200), nrow=100)
bhFunInv <- function(x) {x}
obsTimes <- 1:5
etaVec <- rep(0, 100)
outcomeDat <- gen_IC_data(bhFunInv = bhFunInv, obsTimes = obsTimes, windowHalf = 0.1,
probMiss = 0.1, etaVec = etaVec)

}
