% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RooksNeighFind.R
\name{RooksNeighFind}
\alias{RooksNeighFind}
\title{Classify Rook's Neighbours Comprising Spread Patterns in Vector Fields}
\usage{
RooksNeighFind(vfdf)
}
\arguments{
\item{vfdf}{A data frame as returned by \code{\link{PatternDetect}}}
}
\value{
A data frame similar to vfdf except that it includes an additional
column called NeighType as described above.
}
\description{
After running the \code{\link{PatternDetect}} function, this function enables
classification of neighbour cells. Because the pattern detect function
classifies central cells according to the patterns of vector direction in
their Rook's neighbourhood, the neighbouring grid locations that comprise the
pattern are not labeled. This is remedied by the RooksNeighFind function
which classifies neighbour cells around focal grids classified with one of
the four patterns that the \code{\link{PatternDetect}} function is able to
recognize. The function returns a data frame similar to the input data frame
with a column appended. In the appended column, neighbours surrounding focal
cells labeled with a particular pattern will be labeled as follows:
neighbours of the divergence pattern are labeled with a one, neighbours of
the convergence pattern are labeled with a two, neighbours of the partial
divergence pattern are labeled with a three, and neighbours of the partial
convergence pattern are labeled with a four. In cases where neighbours are
shared, the priority order from lowest to highest is four for partial
convergence to one for divergence. Thus, a neighbour that is shared between a
focal grid classified as a convergence and a nearby focal grid classified as
a divergence will be labeled with a one instead of a two.
}
\examples{
# creating convergence/divergence patterns
Mat1 <- matrix(rep(0,9*9), nrow = 9)
Mat1[3, c(4, 6)] <- 1
Mat1[7, c(4, 6)] <- 1
Mat1[c(4, 6), 3] <- 1
Mat1[c(4, 6), 7] <- 1
Mat1

Mat2 <- matrix(rep(0,9*9), nrow = 9)
Mat2[2, c(4, 6)] <- 1
Mat2[8, c(4, 6)] <- 1
Mat2[c(4, 6), 2] <- 1
Mat2[c(4, 6), 8] <- 1
Mat2

# rasterizing
rast1 <- terra::rast(Mat1)
terra::plot(rast1)
rast2 <- terra::rast(Mat2)
terra::plot(rast2)

# Detecting a divergence
(VFdf1 <- DispField(rast1, rast2, factv1 = 3, facth1 = 3, restricted = TRUE))
(patdf1 <- PatternDetect(VFdf1))
(neighdf1 <- RooksNeighFind(patdf1))
# Rook's neighbour grids are labeled with a one.

# Detecting a convergence
(VFdf2 <- DispField(rast2, rast1, factv1 = 3, facth1 = 3, restricted = TRUE))
(patdf2 <- PatternDetect(VFdf2))
(neighdf2 <- RooksNeighFind(patdf2))
# Rook's neighbour grids are labeled with a two.

}
