% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d-gev.R
\name{dgev.d}
\alias{dgev.d}
\title{d-GEV probability density function}
\usage{
dgev.d(q, mut, sigma0, xi, theta, eta, d, eta2 = NULL, tau = 0, ...)
}
\arguments{
\item{q}{vector of quantiles}

\item{mut, sigma0, xi}{numeric value, giving modified location \eqn{\tilde{\mu}}, scale offset \eqn{\sigma_0} and 
shape parameter \eqn{\xi}.}

\item{theta}{numeric value, giving duration offset \eqn{\theta} (defining curvature of the IDF curve)}

\item{eta}{numeric value, giving duration exponent \eqn{\eta} (defining slope of the IDF curve)}

\item{d}{positive numeric value, giving duration}

\item{eta2}{numeric value, giving a second duration exponent \eqn{\eta_2} (needed for multiscaling). Default: NULL, treated as \eqn{\eta_2=\eta}.}

\item{tau}{numeric value, giving intensity offset \eqn{\tau} (defining flattening of the IDF curve). Default: \eqn{\tau=0}.}

\item{...}{additional parameters passed to \code{\link[evd]{dgev}}}
}
\value{
list containing vectors of density values for given quantiles.
The first element of the list are the density values for the first given duration etc.
}
\description{
Probability density function of duration-dependent GEV distribution
}
\details{
For details on the d-GEV and the parameter definitions, see \link{IDF-package}.
}
\examples{
x <- seq(4,20,0.1)
# calculate probability density for one duration
dgev.d(q=x,mut=4,sigma0=2,xi=0,theta=0.1,eta=0.1,d=1)

# calculate probability density for different durations
ds <- 1:4
dens <- lapply(ds,dgev.d,q=x,mut=4,sigma0=2,xi=0,theta=0.1,eta=0.1)

plot(x,dens[[1]],type='l',ylim = c(0,0.21),ylab = 'Probability Density')
for(i in 2:4){
  lines(x,dens[[i]],lty=i)
}
legend('topright',title = 'Duration',legend = 1:4,lty=1:4)
}
\seealso{
\code{\link{pgev.d}}, \code{\link{qgev.d}}, \code{\link{rgev.d}}
}
