% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportToReport.R
\name{BatchReport}
\alias{BatchReport}
\title{Batch Generation of Graphical and Statistic Report}
\usage{
BatchReport(
  fileName,
  obj,
  selection,
  write_to,
  overwrite = FALSE,
  gating,
  main,
  byrow = FALSE,
  times = 5,
  color_mode = c("white", "black")[1],
  add_key = "panel",
  precision = c("light", "full")[1],
  trunc_labels = 38,
  trans = "asinh",
  bin,
  viewport = "ideas",
  backend = "lattice",
  display_progress = TRUE,
  ...
)
}
\arguments{
\item{fileName, obj}{either one or the other. Path to file(s) to read from for 'fileName' or list of `IFC_data` objects for obj.}

\item{selection}{indices of desired graphs. It can be provided as an integer vector or as a matrix.\cr
In such case, the layout of the matrix will reflect the layout of the extracted graphs for each 'fileName' or ''obj'.\cr
NA value will result in an empty place. When missing, it will be determined by the whole layout of 1st 'fileName' or 'obj' with 'gating' applied when provided}

\item{write_to}{pattern used to export file(s).
Placeholders, like c("\%d/\%s_fromR.pdf", "\%d/\%s_fromR.csv"), will be substituted:\cr
-\%d: with full path directory\cr
-\%p: with first parent directory\cr
-\%e: with extension (without leading .)\cr
-\%s: with shortname (i.e. basename without extension).\cr
Exported file(s) extension(s) will be deduced from this pattern using either 1st 'fileName' or 'obj'. Note that has to be a .pdf and/or .csv.}

\item{overwrite}{whether to overwrite file or not. Default is FALSE.
Note that if TRUE, it will overwrite file. In addition a warning message will be sent.}

\item{gating}{an `IFC_gating` object as extracted by readGatingStrategy(). Default is missing.
If not missing, each `IFC_data` provided in 'obj' or read from 'fileName' will be passed to applyGatingStrategy() before creating the report.}

\item{main}{the main title of the document. Default is missing.}

\item{byrow}{whether to add selected graphs for each file by row or not. Default is FALSE.}

\item{times}{number of files to add before starting a new row or column (depending on 'byrow').}

\item{color_mode}{Whether to extract colors in white or black mode. Default is "white".}

\item{add_key}{whether to draw a "global" key under title or in the first "panel" or "both". Default is "panel".\cr
Accepted values are either: FALSE, "panel", "global", "both" or c("panel", "global").\cr
Note that it only applies when display is seen as overlaying populations.}

\item{precision}{when graphs is a 2D scatter with population overlay, this argument controls amount of information displayed. Default is "light".\cr
-"light", the default, will only display points of same coordinates that are among the other layers.\cr
-"full" will display all the layers.}

\item{trunc_labels}{maximum number of characters to display for labels. Default is 38.}

\item{trans}{name of the transformation function for density graphs. If missing the default, the BasePop[[1]]$densitytrans, if any, will be retrieved, otherwise "asinh" will be used.}

\item{bin}{default number of bin used for histogram. Default is missing.}

\item{viewport}{Either "ideas", "data" or "max" defining limits used for the graph. Default is "ideas".\cr
-"ideas" will use same limits as the one defined in ideas.\cr
-"data" will use data to define limits.\cr
-"max" will use data and regions drawn to define limits.}

\item{backend}{backend used for drawing. Allowed are "lattice", "base", "raster". Default is "lattice".\cr
-"lattice" is the original one used in \pkg{IFC} using \pkg{lattice},\cr
-"base" will produce the plot using \pkg{base},\cr
-"raster" uses "base" for plotting but for 2D graphs points will be produced as \code{\link[graphics]{rasterImage}}.
This has the main advantage of being super fast allowing for plotting a huge amount of points while generating smaller objects (in bytes).
However, plot quality is impacted with "raster" method and resizing can lead to unpleasant looking.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{...}{other parameters to be passed.}
}
\value{
It invisibly returns full path of exported .pdf and/or .csv file(s).
}
\description{
Batch creates graphical an statistical report.
}
