% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_utils.R
\name{parseTrans}
\alias{parseTrans}
\title{Parse Transformation Information}
\usage{
parseTrans(string)
}
\arguments{
\item{string}{character string describing transformation used and its parameters, if any.}
}
\value{
a list with 3 members:\cr
-what, the transformation function,\cr
-args, he parameters to pass to this function (with the exception of the 1st one),\cr
-trans, the transformation instruction coerced to character.
}
\description{
Helper to parse transformation parameter.
}
\details{
-If string is "P" no transformation will be applied.\cr
-If string is of length 1 and coercible to a numeric, smoothLinLog will be applied with 'hyper' parameter set with as.numeric(string) value.\cr
-Otherwise, string will be split with "|", 1st element will be considered as function to call
and all other elements will be passed to this function after being coerced to numeric
in the order they are provided with the exception of 1st one;
if coercion results in NA, the argument will be skipped.
}
\keyword{internal}
