% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractImages_toFile.R
\name{ExtractImages_toFile}
\alias{ExtractImages_toFile}
\title{Shorcut for Batch Images Extraction to Files}
\usage{
ExtractImages_toFile(
  ...,
  objects,
  offsets,
  display_progress = TRUE,
  mode = c("rgb", "gray")[1],
  write_to
)
}
\arguments{
\item{...}{arguments to be passed to \code{\link{objectExtract}} with the exception of 'ifd' and 'bypass'(=TRUE).\cr
If 'param' is provided 'export'(="file"), 'write_to' and 'mode' will be overwritten.\cr
If 'offsets' are not provided extra arguments can also be passed with ... \code{\link{getOffsets}}.\cr
/!\ If not any of 'fileName', 'info' and 'param' can be found in ... then attr(offsets, "fileName_image") will be used as 'fileName' input parameter to pass to \code{\link{objectParam}}.}

\item{objects}{integer vector, IDEAS objects ids numbers to use.
This argument is not mandatory, if missing, the default, all objects will be used.}

\item{offsets}{object of class `IFC_offset`. 
This argument is not mandatory but it may allow to save time for repeated image export on same file.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{mode}{(\code{\link{objectParam}} argument) color mode export. Either "rgb", "gray" . Default is "rgb".}

\item{write_to}{(\code{\link{objectParam}} argument) used to compute exported file name.\cr
Exported "file" extension will be deduced from this pattern. Allowed export are '.bmp', '.jpg', '.jpeg', '.png', '.tif', '.tiff'.
Note that '.bmp' are faster but not compressed producing bigger data.\cr
Placeholders, if found, will be substituted:\cr
-\%d: with full path directory \cr
-\%p: with first parent directory\cr
-\%e: with extension (without leading .)\cr
-\%s: with shortname (i.e. basename without extension)\cr
-\%o: with object_id\cr
-\%c: with channel_id\cr
A good trick is to use "\%d/\%s/\%s_\%o_\%c.tiff".}
}
\value{
It invisibly returns a list of exported file path of corresponding to objects extracted.
}
\description{
Function to shortcut extraction, normalization and eventually colorization of images to matrix ! excludes mask.
}
\details{
arguments of \code{\link{objectExtract}} will be deduced from \code{\link{ExtractImages_toFile}} input arguments.
}
