% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.fqcd.R
\name{lab.fqcd}
\alias{lab.fqcd}
\title{Functional Quality Control Data}
\usage{
lab.fqcd(x, argvals = NULL, rangeval = NULL)
}
\arguments{
\item{x}{A (m x p) matrix or data-frame. Alternatively an (m x p x n) array. 
The m parameter is the number of curves, p defines the number of points observed in each curve, 
and n is the number of replicates.}

\item{argvals}{Argvals, by default: 1:p.}

\item{rangeval}{Range of discretization points, by default: range(argvals).}
}
\description{
It Creates an object of class 'lab.fqcd' to perform statistical quality control. 
This object is used to plot functional data.
}
\examples{
\dontrun{
library(ILS)
data(TG) 
delta <- seq(from = 40 ,to = 850 ,length.out = 1000 )
curves.fqcd <- lab.fqcd(TG, argvals = delta)
windows()
xlab <- "Temperature (0C)"
ylab <- "Mass (\%)"
main <- "TG curves obtained from calcium oxalate"
p <- curves.fqcd$p
col <- terrain.colors(p)
plot(x = curves.fqcd, main, xlab, ylab,legend = FALSE,col = col)
legend(45,70,c(paste("Lab",c(1:7))),
      col = col,lty = 1, lwd = c(rep(1,7),2), cex = 0.7)
      }
}
\references{
\describe{
  \item{}{Febrero-Bande, M. and Oviedo, M. (2012),
   "Statistical computing in functional data analysis: the R package fda.usc". Journal of Statistical Software 51 (4), 1-28.}
  \item{}{Naya, S., Tarrio-Saavedra. J., Lopez- Beceiro, J., Francisco Fernandez, M., Flores, M. and  Artiaga, R. (2014), 
  "Statistical functional approach for interlaboratory studies with thermal data". Journal of Thermal Analysis and Calorimetry, 118,1229-1243.}
}
}

