% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/justload.R
\name{justload}
\alias{justload}
\title{Loading ILSA data into a list}
\usage{
justload(
  inputdir = getwd(),
  population,
  justattributes = FALSE,
  addcountries = FALSE
)
}
\arguments{
\item{inputdir}{a string indicating the path where ILSA 'SPSS' files are stored.}

\item{population}{a character value indicating which files should be loaded. 
For more information on available populations, run \code{ILSAfile.info()} first.}

\item{justattributes}{a logical value indicating if 0 rows should be loaded.
This can be used when we just need to check column attributes. Default is 
\code{FALSE}.}

\item{addcountries}{a logical value indicating if country information should
be added to the elements of the list. This means adding the variable \code{CNTRY}
where needed and adding labels for \code{IDCNTRY} where needed. If \code{FALSE}
(the default), data will be loaded as is.
Country information will be retrieved from 'GitHub' if possible. If not, it will
use the package internal data.}
}
\value{
A list of tibbles.
}
\description{
Load 'SPSS' data from different International Large-Scale Assessments (ILSA),
including: 'TIMSS', 'TIMSS Advanced', 'PIRLS', 'ICCS', 'ICILS', 'CIVED', 'REDS', 'RLII',
and 'SITES' (2006) into a list.
}
\examples{
# Path where raw 'SPSS' files are
input <- system.file("extdata/reds", package = "ILSAmerge")

# Load only attributes
emptylist <- justload(inputdir = input, population = "BCGV1", justattributes = TRUE)

# Load complete data
fulllist <- justload(inputdir = input, population = "BCGV1", justattributes = FALSE)

# Load complete data and add country labels
withcou <- justload(inputdir = input, population = "BCGV1", addcountries = TRUE)

}
