% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/role_sim.R
\name{role_sim}
\alias{role_sim}
\title{Similarity of roles of interconnecting species}
\usage{
role_sim(spe_role_mat)
}
\arguments{
\item{spe_role_mat}{A matrix of 65 columns representing the roles of interconnecting species in the motifs. Columns names are Role1, Role2, Role3 ... Role70.}
}
\value{
Return a numeric value.
}
\description{
The average of Similarity of 65 roles of interconnecting species of multilayer network.
}
\details{
\strong{spe_role_mat}

Should acquire from function \code{motif_role}.
}
\examples{

set.seed(12)
d <- build_net(11,22,21,0.2)
mr <- icmotif_role(d)
role_sim(mr)

set.seed(1)
D <- build_net(11,22,21,0.2)
role_sim(icmotif_role(D))

}
