% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INCA.NormSI.R
\name{INCA.NormSI}
\alias{INCA.NormSI}
\title{INCATome Normalisation by Spike In Probes}
\usage{
INCA.NormSI(x, SpikeFile, wcol, base = 2, mva = TRUE, highlight = NULL)
}
\arguments{
\item{x}{an RGList object}

\item{SpikeFile}{a data.frame specifying the Spike In probe names in a column called "Probe" and the expected relative amounts for each dye, respectively in a "Cy5" and "Cy3" column. For example, a given probe might be expected in a 3:1 ratio thus column "Cy5" would specify 3 and column "Cy3" would specify 1.}

\item{wcol}{an integer specifying the number of the column where Gene Names can be found in the gene annotation table.}

\item{base}{an integer specifying the log base. Default is 2.}

\item{mva}{logical, TRUE to plot MA plots before and after normalisation for each array.}

\item{highlight}{a character vector specifying a set of genes of interest. These will be highlighted in the graphical representations.}
}
\value{
A new RGList object containing the normalised array data. Additionally, if mva is TRUE, MA plots before and after normalisations will be generated for each arrays.
}
\description{
Performs the INCATome normalisation using invariance of Spike In probes for microarray data.
}
\examples{
#Load the INCATome Dataset
data(INCATomeData)
attach(INCATomeData)
dc=INCA.NormSI(RGdataBG,sdata,8,highlight=c("ACTB","PABPC1"))
}
