% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_model.R
\name{select_model}
\alias{select_model}
\title{Select the best correlation structure in the GAMM}
\usage{
select_model(gam_tbl, gamm_tbl)
}
\arguments{
\item{gam_tbl}{Output tibble from the \code{\link{model_gam}} function.}

\item{gamm_tbl}{Output tibble from the \code{\link{model_gamm}} function.}
}
\value{
\code{select_model} returns the same model output tibble as \code{\link{model_gamm}}
but with only \strong{one} final GAMM for each filtered IND~pressure pair.
}
\description{
The function selects and returns the best GAMM out of the six GAMMs computed in
\code{\link{model_gamm}}. In the case that the GAMM without any correlation
structure performs best, the output tibble contains the information from
the original \code{\link{model_gam}} output tibble (therefore needed as input).
}
\details{
The best error structure is chosen here based on the Akaike`s Information
Criterion (AIC). The GAMM with the lowest AIC value is selected, but only if the
AIC difference to the GAMMs with a less complex error structure is greater than 2
(or respectively 4 or 6 depending on the level of nested complexity)
(Burnham and Anderson, 2002). Otherwise the less complex GAMM is chosen.
The following hierarchy of complexity is considered:
\itemize{
  \item no structure < AR1 < AR2 and ARMA1,1 < ARMA2,1 and ARMA1,2
  }
}
\examples{
# Using some models of the Baltic Sea demo data
test_ids <- c(67:70)
gam_tbl <- model_gam_ex[model_gam_ex$id \%in\% test_ids,]
gamm_tbl <- model_gamm(ind_init_ex[test_ids,], filter = gam_tbl$tac)
best_gamm <- select_model(gam_tbl, gamm_tbl)
}
\references{
Burnham, K.P., Anderson, D.R. (2002) Model Selection and Multimodel Inference - A
Practical Information-Theoretic Approach. Springer-Verlag New York.
}
\seealso{
Other IND~pressure modeling functions: \code{\link{find_id}},
  \code{\link{ind_init}}, \code{\link{model_gamm}},
  \code{\link{model_gam}}, \code{\link{plot_diagnostics}},
  \code{\link{plot_model}}, \code{\link{scoring}},
  \code{\link{test_interaction}}
}
