% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_gamm.R
\name{model_gamm}
\alias{model_gamm}
\title{Modeling of indicator responses to single pressures with GAMMs}
\usage{
model_gamm(init_tbl, k = 5, family = stats::gaussian(),
  excl_outlier = NULL, filter = NULL)
}
\arguments{
\item{init_tbl}{The output tibble of the \code{\link{ind_init}} function.}

\item{k}{Choice of knots (for the smoothing function \code{\link{s}}); the
default is 5.}

\item{family}{A description of the error distribution and link to be used in the GAM.
This needs to be defined as a family function (see also \code{\link{family}}). All
standard family functions can be used as well some of the distribution families in
the mgcv package (see \code{\link[mgcv]{family.mgcv}}; e.g.\code{\link[mgcv]{negbin}}).
Note that \code{\link[mgcv]{nb}}, which estimates \code{theta} parameter, cannot be used
for \code{\link[mgcv]{gamm}}.}

\item{excl_outlier}{A list of values identified as outliers in specific
IND~pressure GAMMs, which should be excluded in this modeling step
(the output tibble of this function includes the variable
`pres_outlier`, which is a column-list containing
all indices of values with cook`s distance > 1 (see below). The function
can be re-run again, then excluding all these outliers provided in
\code{$pres_outlier} from the the first run (see example)).}

\item{filter}{logical; a filter used to select specific rows in init_tbl
(row gets selected if value TRUE). That could be the \code{tac} column
in the \code{model_gam} output tibble which indicates whether the model
residuals show TAC.}
}
\value{
Returns a model output tibble that contains for each filtered IND~pressure pair
6 rows with the individual GAMM outputs. The structure remains the same as in
\code{\link{model_gam}} except for the explained deviance, which is not computed
by the gamm function.
The selection of the final correlation structure for each IND~pressure model can be
done manually on this tibble or with an automatized routine using
\code{\link{select_model}}.
}
\description{
\code{model_gamm} accounts for temporal autocorrelation (TAC) in the time series
by fitting Generalized Additive Mixed Models (GAMMs) that include AR or ARMA
correlation structures using the \code{\link[mgcv]{gamm}} function. The GAMMs
are applied to all IND~pressure combinations provided as input or only those
with significant TAC in the GAM residuals (using filter argument).
}
\details{
Modeling first-differenced indicator time series can be an alternative solution
to avoid temporal dependence between observations. However, this approach does
often not help reducing the significant auto-correlation while GAMMs do as found in
Otto \emph{et al.} (2018). Such an extension implies that the single
elements of the response variable are not independent anymore and that the
correlation between the residuals at time t1 and t2 only depends on their time
difference t1 – t2 (Wood, 2006).

In \code{model_gamm} six GAMMs are computed for each filtered IND~pressure pair, i.e.
\enumerate{
  \item no correlation structure (for AIC comparison)
  \item auto-regressive error structure of order p=1 (AR1)
  \item auto-regressive error structure of order p=2 (AR2)
  \item auto-regressive moving average of order p=1 and q=1 (ARMA11)
  \item auto-regressive moving average of order p=1 and q=2 (ARMA12)
  \item auto-regressive moving average of order p=2 and q=1 (ARMA21)
}
}
\examples{
# Using the Baltic Sea demo data in this package
dat_init <- ind_init(
  ind_tbl = data.frame(Cod = ind_ex$Sprat),
  press_tbl = press_ex[, c("Fsprat", "Fher")],
  time = ind_ex[ ,1])
gam_tbl <- model_gam(dat_init)
# Any temporal autocorrelation
gam_tbl$tac
# Applying model_gamm function and passing the $tac variable as filter
gamm_tbl <- model_gamm(dat_init, filter = gam_tbl$tac)
}
\references{
Otto, S.A., Kadin, M., Casini, M., Torres, M.A., Blenckner, T. (2018)
A quantitative framework for selecting and validating food web indicators.
\emph{Ecological Indicators}, 84: 619-631,
doi: https://doi.org/10.1016/j.ecolind.2017.05.045

Wood, S.N. (2006) Generalized Additive Models: An Introduction with R.
Chapman and Hall/CRC Press
}
\seealso{
\code{\link[mgcv]{gamm}} for more information on GAMMs and
\code{\link{plot_diagnostics}} for assessing the model diagnostics

Other IND~pressure modeling functions: \code{\link{find_id}},
  \code{\link{ind_init}}, \code{\link{model_gam}},
  \code{\link{plot_diagnostics}}, \code{\link{plot_model}},
  \code{\link{scoring}}, \code{\link{select_model}},
  \code{\link{test_interaction}}
}
\concept{IND~pressure modeling functions}
