% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_statespace_ed.R
\name{plot_statespace_ed}
\alias{plot_statespace_ed}
\title{Time series plot of Euclidean distance}
\usage{
plot_statespace_ed(x)
}
\arguments{
\item{x}{The output tibble from the \code{\link{statespace_ed}} function.}
}
\value{
The function returns a \code{\link[ggplot2]{ggplot}} object.
}
\description{
\code{plot_statespace_ed} generates a time series plot of the Euclidean
distance in indicator state space from a defined reference conditions.
}
\examples{
# Using the Baltic Sea demo data in the package
ind_sel <- ind_ex[,c(2,3,4,8,10,11)]
  # --> selection of complementary and well performing indicators
ed <- statespace_ed(x = ind_sel, time = ind_ex$Year, ref_time = ind_ex$Year[1])
plot_statespace_ed(x = ed)

# To modify the plot:
p <- plot_statespace_ed(x = ed)
p + ggplot2::geom_point(col = "red") +
  ggplot2::ylab("Eucl. Distance") +
  ggplot2::geom_smooth(col="blue") +
  ggplot2::theme(axis.text = ggplot2::element_text(size = 16),
    axis.title=ggplot2::element_text(size = 18))
}
\seealso{
Other state assessment functions: 
\code{\link{plot_statespace_ch}()},
\code{\link{statespace_ch}()},
\code{\link{statespace_ed}()}
}
\concept{state assessment functions}
