## -----------------------------------------------------------------------------
library(IP)
rhost     <- host('r-project.org')
rhost
class(rhost)

## -----------------------------------------------------------------------------
rhost.hnm <- host(ipv4(rhost))
rhost.hnm 

## -----------------------------------------------------------------------------
fqdn(rhost.hnm)

## -----------------------------------------------------------------------------
ipv4.rir()[ip.match(ipv4(rhost), ipv4.rir())]

## -----------------------------------------------------------------------------
ip.match(ipv4(rhost), ipv4.recovered())

## -----------------------------------------------------------------------------
rdom.whois   <- whois('r-project.org', output=1)
rdom.whois[['r-project.org']]['Registrant Country']

## -----------------------------------------------------------------------------
rhost.whois <- whois(ipv4(rhost),verbose = 2, output=1)
rhost.whois[['r-project.org']]['Organization']

## -----------------------------------------------------------------------------
rhost.whois[['r-project.org']]['NetType']

## -----------------------------------------------------------------------------
h <- host(dn <- c("r-project.org", "cloud.r-project.org" ))
h
length(h)

## -----------------------------------------------------------------------------
data.frame(dn, h)

## -----------------------------------------------------------------------------
ipv4(h)
ipv6(h)
ip(h)

## -----------------------------------------------------------------------------
ipv4.rir()[ip.match(ipv4(h),ipv4.rir())]

## -----------------------------------------------------------------------------
w <- whois(ipv6(h)["cloud.r-project.org"][1])
w[[1]]['OrgName']

## -----------------------------------------------------------------------------
dn <- c("bücher.de")
(dni <- toIdna(dn))

## -----------------------------------------------------------------------------
fromIdna(dni)

## -----------------------------------------------------------------------------
dn <- c("💩.la")
toIdna(dn)

## -----------------------------------------------------------------------------
toIdna(dn,  "IDNA_ALLOW_UNASSIGNED")

## ----warning=FALSE------------------------------------------------------------
dn <- c("bücher.de", "💩.la")
flags <-rep( c( "IDNA_DEFAULT" , "IDNA_ALLOW_UNASSIGNED"), each = length(dn))
dni <- c(dn, toIdna( dn, flags))
host(dni)

