##
##    Utility functions for communicating with the ISPAQ system built to
##    harness the functions defined in the IRISMustangMetrics package.
##
##    Copyright (C) 2012  Mazama Science, Inc.
##    by Jonathan Callahan, jonathan@mazamascience.com
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

################################################################################
# Function to return a JSON string with metadata about current functions
# defined in this package.
#
# TODO:  Whenever new metrics or functions are added to the package, the
# TODO:  jsonString must be updated to include new metadata information.
################################################################################

getMetricFunctionMetadata <- function() {
  
  # The structure of this object tries to capture metadata associated
  # with "business logic" defined in the IRISMustangUtils::generateMetrics_~
  # functions as well as the actual metrics defined in the IRISMustangMetrics::~Metric.R
  # functions.
  #
  # The "business logic" in ISPAQ is found in the ~_metrics.py files.
  # 
  # Each block of json code describes the following:
  #  "<GROUP NAME>": {                        -- Grouping used in python code, often the same as the <BUSINESS_LOGIC>
  #   "businessLogic": "<BUSINESS_LOGIC>",    -- The '~' in the '~_metrics.py' ISPAQ business logic file
  #   "fullDay": true,                        -- Does this metric apply to full days.
  #   "outputType": "<OUTPUT_TYPE>",          -- R code metric class, typically "SingleValue"
  #   "elementNames": ["value"],              -- Metrics output names
  #   "metrics": [                            -- list of metrics generated by metricList returned by IRISMustangMetrics::~Metric.R
  #     "m1", 
  #     "m2", 
  #     ...
  #     ], 
  #   "streamCount": 1,                       -- # of streams of input to IRISMustangMetrics::~Metric.R
  #   "speed": "slow"                         -- Admittedly vague assessment of the speed of the metric calculation. (not used)
  # }, 

  jsonString <- '    
  {
    "PSD": {
      "businessLogic": "PSD", 
      "fullDay": true, 
      "outputType": "GeneralValue", 
      "elementNames": ["value"], 
      "metrics": [
        "pct_above_nhnm", 
        "pct_below_nlnm", 
        "dead_channel_lin", 
        "dead_channel_gsn"
        ], 
      "streamCount": 1, 
      "speed": "slow"
    }, 
    "PSDText": {
      "businessLogic": "PSD",
      "fullDay": true,
      "outputType": "DataFrame",
      "elementNames": null,
      "metrics": [
        "psd_corrected",
        "pdf_text"       
        ],
      "streamCount": 1,
      "speed": "slow"
    },
    "PSDPlot": {        
      "businessLogic": "PSD",
      "fullDay": true,
      "outputType": "plot",
      "elementNames": null,
      "metrics": [
        "pdf_plot"
        ],
      "streamCount": 1,
      "speed": "slow"
    },
    "PDF": {
      "businessLogic": "PSD",
      "fullDay": true,
      "outputType": "DataFrame",
      "elementNames": null,
      "metrics": [
        "pdf"
        ],
      "streamCount": 1,
      "speed": "slow"
    },
    "SNR": {
      "businessLogic": "SNR", 
      "fullDay": false, 
      "outputType": "GeneralValue", 
      "elementNames": ["value"], 
      "metrics": [
        "sample_snr"
        ], 
      "streamCount": 1, 
      "speed": "slow"
    },
    "basicStats": {
      "businessLogic": "simple", 
      "fullDay": true, 
      "outputType": "GeneralValue", 
      "elementNames": ["value"], 
      "metrics": [
        "sample_min", 
        "sample_median", 
        "sample_mean", 
        "sample_max", 
        "sample_rms", 
        "sample_unique"
        ], 
      "streamCount": 1, 
      "speed": "fast"
    }, 
    "crossCorrelation": {
      "businessLogic": "crossCorrelation", 
      "fullDay": false, 
      "outputType": "GeneralValue", 
      "elementNames": ["value","snclq2"], 
      "metrics": [
        "polarity_check"
        ], 
      "streamCount": 2, 
      "speed": "slow"
    },
    "crossTalk": {
      "businessLogic": "crossTalk", 
      "fullDay": false, 
      "outputType": "GeneralValue", 
      "elementNames": ["value"], 
      "metrics": [
        "cross_talk"
        ], 
      "streamCount": 2, 
      "speed": "fast"
    }, 
    "gaps": {
      "businessLogic": "simple", 
      "fullDay": true, 
      "outputType": "GeneralValue", 
      "elementNames": ["value"], 
      "metrics": [
        "num_gaps", 
        "max_gap", 
        "num_overlaps", 
        "max_overlap", 
        "percent_availability"
        ], 
      "streamCount": 1, 
      "speed": "fast"
    }, 
    "orientationCheck": {
      "businessLogic": "orientationCheck", 
      "fullDay": false, 
      "outputType": "GeneralValue", 
      "elementNames": [
         "azimuth_R",
         "backAzimuth",
         "azimuth_Y_obs",
         "azimuth_X_obs",
         "azimuth_Y_meta",
         "azimuth_X_meta",
         "max_Czr",
         "max_C_zr",
         "magnitude"
        ], 
      "metrics": [
        "orientation_check"
        ], 
      "streamCount": 2, 
      "speed": "slow"
    }, 
    "pressureCorrelation": {
      "businessLogic": "pressureCorrelation", 
      "fullDay": false, 
      "outputType": "GeneralValue", 
      "elementNames": ["value"], 
      "metrics": [
        "pressure_effects"
        ], 
      "streamCount": 2, 
      "speed": "fast"
    }, 
    "numSpikes": {
      "businessLogic": "simple", 
      "fullDay": true, 
      "outputType": "GeneralValue", 
      "elementNames": ["value"], 
      "metrics": [
        "num_spikes"
        ], 
      "streamCount": 1, 
      "speed": "fast"
    }, 
    "STALTA": {
      "businessLogic": "simple", 
      "fullDay": true, 
      "outputType": "GeneralValue", 
      "elementNames": ["value"], 
      "metrics": [
        "max_stalta"
        ], 
      "streamCount": 1, 
      "speed": "fast"
    }, 
    "stateOfHealth": {
      "businessLogic": "simple", 
      "fullDay": true, 
      "outputType": "GeneralValue", 
      "elementNames": ["value"], 
      "metrics": [
        "calibration_signal", 
        "timing_correction", 
        "event_begin", 
        "event_end", 
        "event_in_progress", 
        "clock_locked", 
        "amplifier_saturation", 
        "digitizer_clipping", 
        "spikes", 
        "glitches", 
        "missing_padded_data", 
        "telemetry_sync_error", 
        "digital_filter_charging", 
        "suspect_time_tag", 
        "timing_quality"
        ], 
      "streamCount": 1, 
      "speed": "fast"
    }, 
    "transferFunction": {
      "businessLogic": "transferFunction", 
      "fullDay": true, 
      "outputType": "GeneralValue", 
      "elementNames": [
        "gain_ratio", 
        "phase_diff", 
        "ms_coherence"
        ], 
      "metrics": [
        "transfer_function"
        ], 
      "streamCount": 2, 
      "speed": "slow"
    }
  }
'
  
  return(invisible(jsonString))
  
}
