% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.R
\name{ISRaD.extra}
\alias{ISRaD.extra}
\title{ISRaD.extra}
\usage{
ISRaD.extra(database, geodata_directory)
}
\arguments{
\item{database}{ISRaD dataset object}

\item{geodata_directory}{directory where geospatial data are found}
}
\value{
New ISRaD_extra object with derived, transformed, and filled columns.
}
\description{
Fills in transformed and geospatial data where possible, generating an enhanced version of ISRaD.
}
\details{
Fills fraction modern, delta 14C, delta-delta, profile coordinates, bulk density, organic C concentration, and SOC stocks from entered data; fills soil and climatic data from external geospatial data products
}
\examples{
\donttest{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Fill ISRaD.extra data
database.x <- ISRaD.extra(database,
  geodata_directory = system.file("extdata", "geodata_directory", package = "ISRaD")
)
}
}
