% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITNcentrality_function.R
\name{ITNcentrality}
\alias{ITNcentrality}
\title{ITN Centrality}
\usage{
ITNcentrality(gs)
}
\arguments{
\item{gs}{International Trade Network - igraph object}
}
\value{
Table of centrality results (dataframe)
}
\description{
This function calculates a number of centrality metrics for the weighted International Trade Network (ITN)
}
\examples{
require(igraph)
##Create random International Trade Network (igraph object)
ITN<-erdos.renyi.game(75,0.05,directed = TRUE)

##Add edge weights
E(ITN)$weight<-runif(ecount(ITN), 0, 1)

##Add vertex names
V(ITN)$name<-1:vcount(ITN)

##Calculate the centrality measures
ITNCENT<-ITNcentrality(ITN)

}
