% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual_EI_function.R
\name{ei_ind}
\alias{ei_ind}
\title{Individual/Node level E-I Index}
\usage{
ei_ind(gs, attrname)
}
\arguments{
\item{gs}{igraph object}

\item{attrname}{Attribute name}
}
\value{
Group level results dataframe
}
\description{
This function calculates the E-I Index (External-internal) at the individual/node level
}
\examples{
require(igraph)
##Create random network (igraph object)
gs<-erdos.renyi.game(30,0.05,directed = TRUE)

##Add vertex names
V(gs)$name<-1:vcount(gs)

## Add an attribute
V(gs)$letters<- rep(LETTERS[1:5],6)

##Calculate the Individual E-I Results
EI_IND_DATAFRAME<-ei_ind(gs,"letters")

}
