% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importExport.R
\name{quickRun}
\alias{quickRun}
\title{Simple evaluation of contour-shifting}
\usage{
quickRun(obsNCDF, predNCDF, predYears, startYear, month, outputFile, level,
  datTypeObs = "bootstrap")
}
\arguments{
\item{obsNCDF}{filepath for observed data array (see details for info about array structure)}

\item{predNCDF}{filepath for predicted data array (see details for info about array structure)}

\item{predYears}{vectors of years for which to make prediction}

\item{startYear}{first year to use when learning model}

\item{month}{month of prediction}

\item{outputFile}{filepath for where bias-corrected netCDF file should be stored}

\item{level}{concentration level for which to build contour}

\item{datTypeObs}{string of either "bootstrap" or "simple" indicating the file type of the observation (see details for info about array structure)}
}
\value{
netCDF file of dimension years by longitude (304) by latitude (448) with indicators for where ice is predicted after bias correction.
 (1: ice-covered, 0: not ice, NA: land). Grid boxes have been categorized as ice if their centers are ice covered (within R the bias-corrected contours are
 not restricted to align to a grid).
}
\description{
Reads in netCDF files of observations and predictions, performs bias correction,
and exports a new netCDF file with bias-corrected predictions
}
\details{
The predicted data array, \code{predNCDF}, should be a netCDF file with a single array of dimension: years x longitude (304) x latitude (448).
The variable should be named \code{iceInd}. The values in the array should indicate whether each grid box is
categorized to contain ice (1: ice-covered, 0: no ice, NA: land).
The observed data array, \code{obsNCDF}, should be a netCDF file with a single array of dimension: years x longitude (304) x latitude (448).
 The observed data array, \code{obsNCDF}, can be formatted  the same as \code{predNCDF}
if \code{datTypeObs = "simple"}. Alternatively, if \code{datTypeObs = "bootstrap"} the array values can be ice concentration values
obtained from the National Aeronautics and Space Administration (NASA) satellites Nimbus-7
SMMR and DMSP SSM/I-SSMIS and processed by the bootstrap algorithm. Data should be retained in the same format as given by bootstrap
(including indicators for missing data, land etc.). The variable should be named "conc".
}
\examples{
\dontrun{
quickRun(obsNCDF = "/obs.nc", predNCDF = "/pred.nc", predYears = c(2001:2013),
         startYear = 1980, month = 2, outputFile = "/outputFile.nc", level = 15,
         datTypeObs = "simple")
}
}
\references{
Bootstrap sea ice concentration:
Comiso, J., 2000, updated 2015: Bootstrap sea ice concentrations from Nimbus-7 SMMR and
DMSP SSM/I-SSMIS. version 2. \url{http://nsidc.org/data/nsidc-0079}
}
