% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBootstrap.R
\name{readBootstrap}
\alias{readBootstrap}
\title{Read individual bootstrap binary file}
\usage{
readBootstrap(fileName, nX = 304, nY = 448)
}
\arguments{
\item{fileName}{File name for binary bootstrap data}

\item{nX}{dimension in the x (defaults to value for Northern Polar stereographic grid: 304)}

\item{nY}{dimension in the y (defaults to value for Northern Polar stereographic grid: 448)}
}
\value{
numeric vector of concentrations
}
\description{
Read in individual binary files of monthly observation data. The observations are from the monthly sea ice concentration
obtained from the National Aeronautics and Space Administration (NASA) satellites Nimbus-7
SMMR and DMSP SSM/I-SSMIS and processed by the bootstrap algorithm. The results
are distributed by the National Snow and Ice Data Center (Comiso 2000, updated 2015).
Functions assume file name conventions are the same as used by NSIDC.
}
\examples{
\dontrun{
#fileName should be the binary file
rawData <- readBootstrap(fileName)
}
}
\references{
Bootstrap sea ice concentration:

Comiso, J., 2000, updated 2015: Bootstrap sea ice concentrations from Nimbus-7 SMMR and
DMSP SSM/I-SSMIS. version 2. \url{http://nsidc.org/data/nsidc-0079}
}
