% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonAttentionLevel.R
\name{NonAttentionLevel}
\alias{NonAttentionLevel}
\title{Estimates levels of non-attention.}
\usage{
NonAttentionLevel(EffectivenessOfSolution,
LossProduction,
Id,
SafetyMargin=1.25,
Verbose=TRUE)
}
\arguments{
\item{EffectivenessOfSolution}{Output generated by the function
`EffectivenessOfSolution`}

\item{LossProduction}{Output generated by the function  `LossProduction`}

\item{Id}{Logical vector indicating the lines of the `EffectivenessOfSolution`
that are relevant. Output generated by the function
SelectEffectivenessOfSolution}

\item{SafetyMargin}{Safety Margin (Default=1.25)}

\item{Verbose}{Logical value (TRUE/FALSE). TRUE displays the results of the
analysis.}
}
\value{
The function returns levels of non-attention.
}
\description{
Functions to estimate E.S., income gain (I.G.), percentage of
 I.G.=P.I.G., and non-attention level (N.A.L.) of each S.S. per L.S., and
 their partial sum of I.G. and P.I.G. of S.S. inside each L.S., and the total
 of I.G. and P.I.G. on the productive system.
}
\examples{
library(ImportanceIndice)
data("DataLossSource")
data("DataSolutionSource")
data("DataProduction")
data("DataNumberSamples")

Distribution_LossSource(DataLossSource)
Distribution_SolutionSource(DataSolutionSource)

#################################################
###################################################



LS=LossSource(DataLoss = DataLossSource,DataProd = DataProduction,verbose = TRUE)
LS

LP=LossProduction(Data=DataLossSource,Prod = DataProduction,
                 Evaluation=DataNumberSamples,
                 SegurityMargen=0.75,MaximumToleranceOfLossFruits=1)
LP


ES=EffectivenessOfSolution(DataLossSource=DataLossSource,
                          DataSolutionSource=DataSolutionSource,Production =DataProduction)
ES




id=SelectEffectivenessOfSolution(ES)
id=c(TRUE , TRUE,  TRUE , FALSE,  TRUE)


SS=SolutionSource(SolutionData = DataSolutionSource,
                 EffectivenessOfSolution = ES,Production = DataProduction,Id = id)
SS


NAL=NonAttentionLevel(EffectivenessOfSolution = ES,LossProduction = LP,Id = id,Verbose=TRUE)
NAL
}
\seealso{
\code{\link{EffectivenessOfSolution}} ,
 \code{\link{NonAttentionLevel}}  ,  \code{\link{LossSource}}
}
\author{
Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
