/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;

public class HyBRDoubleIterationMonitor
extends AbstractDoubleIterationMonitor {
    protected HyBRStoppingCondition stoppingCondition;
    protected int maxIter;
    protected double dtol;
    protected double initR;
    protected double regularizationParameter;

    public HyBRDoubleIterationMonitor() {
        this.maxIter = 100;
        this.dtol = 100000.0;
        this.stoppingCondition = HyBRStoppingCondition.PERFORMED_MAX_NUMBER_OF_ITERATIONS;
    }

    public HyBRDoubleIterationMonitor(int n, double d) {
        this.maxIter = n;
        this.dtol = d;
        this.stoppingCondition = HyBRStoppingCondition.PERFORMED_MAX_NUMBER_OF_ITERATIONS;
    }

    public boolean converged(double d, DoubleMatrix1D doubleMatrix1D) throws IterativeSolverDoubleNotConvergedException {
        if (!this.isFirst()) {
            this.reporter.monitor(d, doubleMatrix1D, this.iter);
        }
        this.residual = d;
        return this.convergedI(d, doubleMatrix1D);
    }

    public boolean converged(double d) throws IterativeSolverDoubleNotConvergedException {
        if (!this.isFirst()) {
            this.reporter.monitor(d, this.iter);
        }
        this.residual = d;
        return this.convergedI(d);
    }

    protected boolean convergedI(double d) throws IterativeSolverDoubleNotConvergedException {
        if (this.isFirst()) {
            this.initR = d;
        }
        if (this.initR != -1.0 && d > this.dtol * this.initR) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter + 1) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Iterations, this);
        }
        if (Double.isNaN(d)) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    protected boolean convergedI(double d, DoubleMatrix1D doubleMatrix1D) throws IterativeSolverDoubleNotConvergedException {
        return this.convergedI(d);
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int n) {
        this.maxIter = n;
    }

    public void setDivergenceTolerance(double d) {
        this.dtol = d;
    }

    public double getDivergenceTolerance() {
        return this.dtol;
    }

    public double getRegularizationParameter() {
        return this.regularizationParameter;
    }

    public void setRegularizationParameter(double d) {
        this.regularizationParameter = d;
    }

    public void setStoppingCondition(HyBRStoppingCondition hyBRStoppingCondition) {
        this.stoppingCondition = hyBRStoppingCondition;
    }

    public HyBRStoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public int iterations() {
        return Math.min(this.iter, this.maxIter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HyBRStoppingCondition {
        FLAT_GCV_CURVE,
        MIN_OF_GCV_CURVE_WITHIN_WINDOW_OF_4_ITERATIONS,
        PERFORMED_MAX_NUMBER_OF_ITERATIONS;

    }
}

