/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix3D;
import cern.colt.matrix.tfloat.impl.SelectedDenseFloatMatrix1D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultFirst;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_1D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_1D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFloatMatrix1D
extends FloatMatrix1D {
    private static final long serialVersionUID = 1L;
    private FloatFFT_1D fft;
    private FloatDCT_1D dct;
    private FloatDST_1D dst;
    private FloatDHT_1D dht;
    protected float[] elements;

    public DenseFloatMatrix1D(float[] fArray) {
        this(fArray.length);
        this.assign(fArray);
    }

    public DenseFloatMatrix1D(int n) {
        this.setUp(n);
        this.elements = new float[n];
    }

    public DenseFloatMatrix1D(int n, float[] fArray, int n2, int n3, boolean bl) {
        this.setUp(n, n2, n3);
        this.elements = fArray;
        this.isNoView = !bl;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction) {
        if (this.size == 0) {
            return Float.NaN;
        }
        float f = 0.0f;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = this.size - i * n2;
                final int n4 = i == n - 1 ? 0 : n3 - n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int n = DenseFloatMatrix1D.this.zero + (n3 - 1) * DenseFloatMatrix1D.this.stride;
                        float f = floatFunction.apply(DenseFloatMatrix1D.this.elements[n]);
                        int n2 = n3 - 1;
                        while (--n2 >= n4) {
                            f = floatFloatFunction.apply(f, floatFunction.apply(DenseFloatMatrix1D.this.elements[n -= DenseFloatMatrix1D.this.stride]));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            int n5 = this.zero + (this.size - 1) * this.stride;
            f = floatFunction.apply(this.elements[n5]);
            int n6 = this.size - 1;
            while (--n6 >= 0) {
                f = floatFloatFunction.apply(f, floatFunction.apply(this.elements[n5 -= this.stride]));
            }
        }
        return f;
    }

    public float aggregate(final FloatFloatFunction floatFloatFunction, final FloatFunction floatFunction, IntArrayList intArrayList) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int n = DenseFloatMatrix1D.this.zero + nArray[n4] * DenseFloatMatrix1D.this.stride;
                        float f = floatFunction.apply(DenseFloatMatrix1D.this.elements[n]);
                        for (int i = n4 + 1; i < n5; ++i) {
                            n = DenseFloatMatrix1D.this.zero + nArray[i] * DenseFloatMatrix1D.this.stride;
                            float f2 = DenseFloatMatrix1D.this.elements[n];
                            f = floatFloatFunction.apply(f, floatFunction.apply(f2));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            int n6 = this.zero + nArray[0] * this.stride;
            f = floatFunction.apply(this.elements[n6]);
            for (int i = 1; i < n; ++i) {
                n6 = this.zero + nArray[i] * this.stride;
                float f2 = this.elements[n6];
                f = floatFloatFunction.apply(f, floatFunction.apply(f2));
            }
        }
        return f;
    }

    public float aggregate(FloatMatrix1D floatMatrix1D, final FloatFloatFunction floatFloatFunction, final FloatFloatFunction floatFloatFunction2) {
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D)) {
            return super.aggregate(floatMatrix1D, floatFloatFunction, floatFloatFunction2);
        }
        this.checkSize(floatMatrix1D);
        if (this.size == 0) {
            return Float.NaN;
        }
        final int n = (int)floatMatrix1D.index(0);
        final int n2 = floatMatrix1D.stride();
        final float[] fArray = (float[])floatMatrix1D.elements();
        float f = 0.0f;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int n3 = DenseFloatMatrix1D.this.zero + n5 * DenseFloatMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        float f = floatFloatFunction2.apply(DenseFloatMatrix1D.this.elements[n3], fArray[n22]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            f = floatFloatFunction.apply(f, floatFloatFunction2.apply(DenseFloatMatrix1D.this.elements[n3 += DenseFloatMatrix1D.this.stride], fArray[n22 += n2]));
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            f = ConcurrencyUtils.waitForCompletion(futureArray, floatFloatFunction);
        } else {
            f = floatFloatFunction2.apply(this.elements[this.zero], fArray[n]);
            int n7 = this.zero;
            int n8 = n;
            for (int i = 1; i < this.size; ++i) {
                f = floatFloatFunction.apply(f, floatFloatFunction2.apply(this.elements[n7 += this.stride], fArray[n8 += n2]));
            }
        }
        return f;
    }

    public FloatMatrix1D assign(final FloatFunction floatFunction) {
        int n;
        float f;
        if (floatFunction instanceof FloatMult) {
            f = ((FloatMult)floatFunction).multiplicator;
            if (f == 1.0f) {
                return this;
            }
        } else {
            f = 0.0f;
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseFloatMatrix1D.this.zero + n3 * DenseFloatMatrix1D.this.stride;
                        if (floatFunction instanceof FloatMult) {
                            for (int i = n3; i < n4; ++i) {
                                int n2 = n;
                                DenseFloatMatrix1D.this.elements[n2] = DenseFloatMatrix1D.this.elements[n2] * f;
                                n += DenseFloatMatrix1D.this.stride;
                            }
                        } else {
                            for (int i = n3; i < n4; ++i) {
                                DenseFloatMatrix1D.this.elements[n] = floatFunction.apply(DenseFloatMatrix1D.this.elements[n]);
                                n += DenseFloatMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero - this.stride;
            if (floatFunction instanceof FloatMult) {
                int n6 = this.size;
                while (--n6 >= 0) {
                    this.elements[n5 += this.stride] = this.elements[n5] * f;
                }
            } else {
                int n7 = this.size;
                while (--n7 >= 0) {
                    this.elements[n5 += this.stride] = floatFunction.apply(this.elements[n5]);
                }
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final FloatProcedure floatProcedure, final FloatFunction floatFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseFloatMatrix1D.this.zero + n3 * DenseFloatMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            if (floatProcedure.apply(DenseFloatMatrix1D.this.elements[n])) {
                                DenseFloatMatrix1D.this.elements[n] = floatFunction.apply(DenseFloatMatrix1D.this.elements[n]);
                            }
                            n += DenseFloatMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (floatProcedure.apply(this.elements[n5])) {
                    this.elements[n5] = floatFunction.apply(this.elements[n5]);
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final FloatProcedure floatProcedure, final float f) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseFloatMatrix1D.this.zero + n3 * DenseFloatMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            if (floatProcedure.apply(DenseFloatMatrix1D.this.elements[n])) {
                                DenseFloatMatrix1D.this.elements[n] = f;
                            }
                            n += DenseFloatMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (floatProcedure.apply(this.elements[n5])) {
                    this.elements[n5] = f;
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final float f) {
        final float[] fArray = this.elements;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseFloatMatrix1D.this.zero + n3 * DenseFloatMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            fArray[n] = f;
                            n += DenseFloatMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                fArray[n5] = f;
                n5 += this.stride;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final float[] fArray) {
        if (fArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + fArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(fArray, 0, this.elements, 0, fArray.length);
        } else if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseFloatMatrix1D.this.zero + n3 * DenseFloatMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            DenseFloatMatrix1D.this.elements[n] = fArray[i];
                            n += DenseFloatMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n5] = fArray[i];
                n5 += this.stride;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(FloatMatrix1D floatMatrix1D) {
        Object object;
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D)) {
            super.assign(floatMatrix1D);
            return this;
        }
        DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D;
        if (denseFloatMatrix1D == this) {
            return this;
        }
        this.checkSize(denseFloatMatrix1D);
        if (this.isNoView && denseFloatMatrix1D.isNoView) {
            System.arraycopy(denseFloatMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseFloatMatrix1D)) {
            object = denseFloatMatrix1D.copy();
            if (!(object instanceof DenseFloatMatrix1D)) {
                super.assign(floatMatrix1D);
                return this;
            }
            denseFloatMatrix1D = (DenseFloatMatrix1D)object;
        }
        object = denseFloatMatrix1D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n = (int)denseFloatMatrix1D.index(0);
        final int n2 = denseFloatMatrix1D.stride;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((float[])object){
                    final /* synthetic */ float[] val$elementsOther;
                    {
                        this.val$elementsOther = fArray;
                    }

                    public void run() {
                        int n3 = DenseFloatMatrix1D.this.zero + n5 * DenseFloatMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseFloatMatrix1D.this.elements[n3] = this.val$elementsOther[n22];
                            n3 += DenseFloatMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = (float)object[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(FloatMatrix1D floatMatrix1D, final FloatFloatFunction floatFloatFunction) {
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D)) {
            super.assign(floatMatrix1D, floatFloatFunction);
            return this;
        }
        this.checkSize(floatMatrix1D);
        final int n = (int)floatMatrix1D.index(0);
        final int n2 = floatMatrix1D.stride();
        final float[] fArray = (float[])floatMatrix1D.elements();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = DenseFloatMatrix1D.this.zero + n5 * DenseFloatMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        if (floatFloatFunction == FloatFunctions.mult) {
                            for (int i = n5; i < n6; ++i) {
                                int n3 = n9;
                                DenseFloatMatrix1D.this.elements[n3] = DenseFloatMatrix1D.this.elements[n3] * fArray[n22];
                                n9 += DenseFloatMatrix1D.this.stride;
                                n22 += n2;
                            }
                        } else if (floatFloatFunction == FloatFunctions.div) {
                            for (int i = n5; i < n6; ++i) {
                                int n4 = n9;
                                DenseFloatMatrix1D.this.elements[n4] = DenseFloatMatrix1D.this.elements[n4] / fArray[n22];
                                n9 += DenseFloatMatrix1D.this.stride;
                                n22 += n2;
                            }
                        } else if (floatFloatFunction instanceof FloatPlusMultFirst) {
                            float f = ((FloatPlusMultFirst)floatFloatFunction).multiplicator;
                            if (f == 0.0f) {
                                for (int i = n5; i < n6; ++i) {
                                    DenseFloatMatrix1D.this.elements[n9] = fArray[n22];
                                    n9 += DenseFloatMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (f == 1.0f) {
                                for (int i = n5; i < n6; ++i) {
                                    int n52 = n9;
                                    DenseFloatMatrix1D.this.elements[n52] = DenseFloatMatrix1D.this.elements[n52] + fArray[n22];
                                    n9 += DenseFloatMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (f == -1.0f) {
                                for (int i = n5; i < n6; ++i) {
                                    DenseFloatMatrix1D.this.elements[n9] = fArray[n22] - DenseFloatMatrix1D.this.elements[n9];
                                    n9 += DenseFloatMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else {
                                for (int i = n5; i < n6; ++i) {
                                    DenseFloatMatrix1D.this.elements[n9] = f * DenseFloatMatrix1D.this.elements[n9] + fArray[n22];
                                    n9 += DenseFloatMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            }
                        } else if (floatFloatFunction instanceof FloatPlusMultSecond) {
                            float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
                            if (f == 0.0f) {
                                return;
                            }
                            if (f == 1.0f) {
                                for (int i = n5; i < n6; ++i) {
                                    int n62 = n9;
                                    DenseFloatMatrix1D.this.elements[n62] = DenseFloatMatrix1D.this.elements[n62] + fArray[n22];
                                    n9 += DenseFloatMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (f == -1.0f) {
                                for (int i = n5; i < n6; ++i) {
                                    int n7 = n9;
                                    DenseFloatMatrix1D.this.elements[n7] = DenseFloatMatrix1D.this.elements[n7] - fArray[n22];
                                    n9 += DenseFloatMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else {
                                for (int i = n5; i < n6; ++i) {
                                    int n8 = n9;
                                    DenseFloatMatrix1D.this.elements[n8] = DenseFloatMatrix1D.this.elements[n8] + f * fArray[n22];
                                    n9 += DenseFloatMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            }
                        } else {
                            for (int i = n5; i < n6; ++i) {
                                DenseFloatMatrix1D.this.elements[n9] = floatFloatFunction.apply(DenseFloatMatrix1D.this.elements[n9], fArray[n22]);
                                n9 += DenseFloatMatrix1D.this.stride;
                                n22 += n2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            if (floatFloatFunction == FloatFunctions.mult) {
                for (int i = 0; i < this.size; ++i) {
                    int n9 = n7;
                    this.elements[n9] = this.elements[n9] * fArray[n8];
                    n7 += this.stride;
                    n8 += n2;
                }
            } else if (floatFloatFunction == FloatFunctions.div) {
                for (int i = 0; i < this.size; ++i) {
                    int n10 = n7;
                    this.elements[n10] = this.elements[n10] / fArray[n8];
                    n7 += this.stride;
                    n8 += n2;
                }
            } else if (floatFloatFunction instanceof FloatPlusMultSecond) {
                float f = ((FloatPlusMultSecond)floatFloatFunction).multiplicator;
                if (f == 0.0f) {
                    return this;
                }
                if (f == 1.0f) {
                    for (int i = 0; i < this.size; ++i) {
                        int n11 = n7;
                        this.elements[n11] = this.elements[n11] + fArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                } else if (f == -1.0f) {
                    for (int i = 0; i < this.size; ++i) {
                        int n12 = n7;
                        this.elements[n12] = this.elements[n12] - fArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                } else {
                    for (int i = 0; i < this.size; ++i) {
                        int n13 = n7;
                        this.elements[n13] = this.elements[n13] + f * fArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                }
            } else {
                for (int i = 0; i < this.size; ++i) {
                    this.elements[n7] = floatFloatFunction.apply(this.elements[n7], fArray[n8]);
                    n7 += this.stride;
                    n8 += n2;
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = DenseFloatMatrix1D.this.zero + n5 * DenseFloatMatrix1D.this.stride;
                        for (int i = n5; i < n6; ++i) {
                            if (DenseFloatMatrix1D.this.elements[n2] != 0.0f) {
                                ++n;
                            }
                            n2 += DenseFloatMatrix1D.this.stride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[n7] != 0.0f) {
                    ++n;
                }
                n7 += this.stride;
            }
        }
        return n;
    }

    public void dct(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct == null) {
            this.dct = new FloatDCT_1D(this.size);
        }
        if (this.isNoView) {
            this.dct.forward(this.elements, bl);
        } else {
            FloatMatrix1D floatMatrix1D = this.copy();
            this.dct.forward((float[])floatMatrix1D.elements(), bl);
            this.assign((float[])floatMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht == null) {
            this.dht = new FloatDHT_1D(this.size);
        }
        if (this.isNoView) {
            this.dht.forward(this.elements);
        } else {
            FloatMatrix1D floatMatrix1D = this.copy();
            this.dht.forward((float[])floatMatrix1D.elements());
            this.assign((float[])floatMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst == null) {
            this.dst = new FloatDST_1D(this.size);
        }
        if (this.isNoView) {
            this.dst.forward(this.elements, bl);
        } else {
            FloatMatrix1D floatMatrix1D = this.copy();
            this.dst.forward((float[])floatMatrix1D.elements(), bl);
            this.assign((float[])floatMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public float[] elements() {
        return this.elements;
    }

    public void fft() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.realForward(this.elements);
        } else {
            FloatMatrix1D floatMatrix1D = this.copy();
            this.fft.realForward((float[])floatMatrix1D.elements());
            this.assign((float[])floatMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DenseFComplexMatrix1D getFft() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        float[] fArray = this.isNoView ? this.elements : (float[])this.copy().elements();
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(this.size);
        float[] fArray2 = denseFComplexMatrix1D.elements();
        System.arraycopy(fArray, 0, fArray2, 0, this.size);
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        this.fft.realForwardFull(fArray2);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix1D;
    }

    public DenseFComplexMatrix1D getIfft(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        float[] fArray = this.isNoView ? this.elements : (float[])this.copy().elements();
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D(this.size);
        float[] fArray2 = denseFComplexMatrix1D.elements();
        System.arraycopy(fArray, 0, fArray2, 0, this.size);
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        this.fft.realInverseFull(fArray2, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseFComplexMatrix1D;
    }

    public void getNonZeros(IntArrayList intArrayList, FloatArrayList floatArrayList) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = floatArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            floatArrayList.clear();
        }
        int n = this.size % 2;
        int n2 = this.zero;
        if (n == 1) {
            float f = this.elements[n2];
            if (f != 0.0f) {
                if (bl2) {
                    intArrayList.add(0);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
            }
            n2 += this.stride;
        }
        for (int i = n; i < this.size; i += 2) {
            float f = this.elements[n2];
            if (f != 0.0f) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
            }
            if ((f = this.elements[n2 += this.stride]) != 0.0f) {
                if (bl2) {
                    intArrayList.add(i + 1);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
            }
            n2 += this.stride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, FloatArrayList floatArrayList) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = floatArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            floatArrayList.clear();
        }
        int n = this.size % 2;
        int n2 = this.zero;
        if (n == 1) {
            float f = this.elements[n2];
            if (f > 0.0f) {
                if (bl2) {
                    intArrayList.add(0);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
            }
            n2 += this.stride;
        }
        for (int i = n; i < this.size; i += 2) {
            float f = this.elements[n2];
            if (f > 0.0f) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
            }
            if ((f = this.elements[n2 += this.stride]) > 0.0f) {
                if (bl2) {
                    intArrayList.add(i + 1);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
            }
            n2 += this.stride;
        }
    }

    public void getNegativeValues(IntArrayList intArrayList, FloatArrayList floatArrayList) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = floatArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            floatArrayList.clear();
        }
        int n = this.size % 2;
        int n2 = this.zero;
        if (n == 1) {
            float f = this.elements[n2];
            if (f < 0.0f) {
                if (bl2) {
                    intArrayList.add(0);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
            }
            n2 += this.stride;
        }
        for (int i = n; i < this.size; i += 2) {
            float f = this.elements[n2];
            if (f < 0.0f) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
            }
            if ((f = this.elements[n2 += this.stride]) < 0.0f) {
                if (bl2) {
                    intArrayList.add(i + 1);
                }
                if (bl) {
                    floatArrayList.add(f);
                }
            }
            n2 += this.stride;
        }
    }

    public float[] getMaxLocation() {
        int n = 0;
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            float[][] fArray = new float[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = DenseFloatMatrix1D.this.zero + n5 * DenseFloatMatrix1D.this.stride;
                        float f = DenseFloatMatrix1D.this.elements[n];
                        int n2 = (n - DenseFloatMatrix1D.this.zero) / DenseFloatMatrix1D.this.stride;
                        for (int i = n5 + 1; i < n6; ++i) {
                            if (!(f < DenseFloatMatrix1D.this.elements[n += DenseFloatMatrix1D.this.stride])) continue;
                            f = DenseFloatMatrix1D.this.elements[n];
                            n2 = (n - DenseFloatMatrix1D.this.zero) / DenseFloatMatrix1D.this.stride;
                        }
                        return new float[]{f, n2};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    fArray[n3] = (float[])futureArray[n3].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (!(f < fArray[n3][0])) continue;
                    f = fArray[n3][0];
                    n = (int)fArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[this.zero];
            n = 0;
            int n7 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (!(f < this.elements[n7 += this.stride])) continue;
                f = this.elements[n7];
                n = (n7 - this.zero) / this.stride;
            }
        }
        return new float[]{f, n};
    }

    public float[] getMinLocation() {
        int n = 0;
        float f = 0.0f;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            float[][] fArray = new float[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int n = DenseFloatMatrix1D.this.zero + n5 * DenseFloatMatrix1D.this.stride;
                        float f = DenseFloatMatrix1D.this.elements[n];
                        int n2 = (n - DenseFloatMatrix1D.this.zero) / DenseFloatMatrix1D.this.stride;
                        for (int i = n5 + 1; i < n6; ++i) {
                            if (!(f > DenseFloatMatrix1D.this.elements[n += DenseFloatMatrix1D.this.stride])) continue;
                            f = DenseFloatMatrix1D.this.elements[n];
                            n2 = (n - DenseFloatMatrix1D.this.zero) / DenseFloatMatrix1D.this.stride;
                        }
                        return new float[]{f, n2};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    fArray[n3] = (float[])futureArray[n3].get();
                }
                f = fArray[0][0];
                n = (int)fArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (!(f > fArray[n3][0])) continue;
                    f = fArray[n3][0];
                    n = (int)fArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            f = this.elements[this.zero];
            n = 0;
            int n7 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (!(f > this.elements[n7 += this.stride])) continue;
                f = this.elements[n7];
                n = (n7 - this.zero) / this.stride;
            }
        }
        return new float[]{f, n};
    }

    public float getQuick(int n) {
        return this.elements[this.zero + n * this.stride];
    }

    public void idct(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct == null) {
            this.dct = new FloatDCT_1D(this.size);
        }
        if (this.isNoView) {
            this.dct.inverse(this.elements, bl);
        } else {
            FloatMatrix1D floatMatrix1D = this.copy();
            this.dct.inverse((float[])floatMatrix1D.elements(), bl);
            this.assign((float[])floatMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht == null) {
            this.dht = new FloatDHT_1D(this.size);
        }
        if (this.isNoView) {
            this.dht.inverse(this.elements, bl);
        } else {
            FloatMatrix1D floatMatrix1D = this.copy();
            this.dht.inverse((float[])floatMatrix1D.elements(), bl);
            this.assign((float[])floatMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst == null) {
            this.dst = new FloatDST_1D(this.size);
        }
        if (this.isNoView) {
            this.dst.inverse(this.elements, bl);
        } else {
            FloatMatrix1D floatMatrix1D = this.copy();
            this.dst.inverse((float[])floatMatrix1D.elements(), bl);
            this.assign((float[])floatMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.realInverse(this.elements, bl);
        } else {
            FloatMatrix1D floatMatrix1D = this.copy();
            this.fft.realInverse((float[])floatMatrix1D.elements(), bl);
            this.assign((float[])floatMatrix1D.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public FloatMatrix1D like(int n) {
        return new DenseFloatMatrix1D(n);
    }

    public FloatMatrix2D like2D(int n, int n2) {
        return new DenseFloatMatrix2D(n, n2);
    }

    public FloatMatrix2D reshape(final int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseFloatMatrix2D denseFloatMatrix2D = new DenseFloatMatrix2D(n, n2);
        final float[] fArray = (float[])((FloatMatrix2D)denseFloatMatrix2D).elements();
        final int n3 = (int)((AbstractMatrix2D)denseFloatMatrix2D).index(0, 0);
        final int n4 = denseFloatMatrix2D.rowStride();
        final int n5 = denseFloatMatrix2D.columnStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n6 = Math.min(n6, this.size);
            Future[] futureArray = new Future[n6];
            int n7 = n2 / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n2 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n6 = n3 + i * n5;
                            int n2 = DenseFloatMatrix1D.this.zero + i * n * DenseFloatMatrix1D.this.stride;
                            for (int j = 0; j < n; ++j) {
                                fArray[n6] = DenseFloatMatrix1D.this.elements[n2];
                                n6 += n4;
                                n2 += DenseFloatMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = this.zero;
            for (int i = 0; i < n2; ++i) {
                int n11 = n3 + i * n5;
                for (int j = 0; j < n; ++j) {
                    fArray[n11] = this.elements[n10];
                    n11 += n4;
                    n10 += this.stride;
                }
            }
        }
        return denseFloatMatrix2D;
    }

    public FloatMatrix3D reshape(int n, final int n2, final int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseFloatMatrix3D denseFloatMatrix3D = new DenseFloatMatrix3D(n, n2, n3);
        final float[] fArray = (float[])((FloatMatrix3D)denseFloatMatrix3D).elements();
        final int n4 = (int)((AbstractMatrix3D)denseFloatMatrix3D).index(0, 0, 0);
        final int n5 = denseFloatMatrix3D.sliceStride();
        final int n6 = denseFloatMatrix3D.rowStride();
        final int n7 = denseFloatMatrix3D.columnStride();
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n8 = Math.min(n8, this.size);
            Future[] futureArray = new Future[n8];
            int n9 = n / n8;
            for (int i = 0; i < n8; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n8 - 1 ? n : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n10; i < n11; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n = n4 + i * n5 + j * n7;
                                int n22 = DenseFloatMatrix1D.this.zero + (i * n2 * n3 + j * n2) * DenseFloatMatrix1D.this.stride;
                                for (int k = 0; k < n2; ++k) {
                                    fArray[n] = DenseFloatMatrix1D.this.elements[n22];
                                    n += n6;
                                    n22 += DenseFloatMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = this.zero;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n13 = n4 + i * n5 + j * n7;
                    for (int k = 0; k < n2; ++k) {
                        fArray[n13] = this.elements[n12];
                        n13 += n6;
                        n12 += this.stride;
                    }
                }
            }
        }
        return denseFloatMatrix3D;
    }

    public void setQuick(int n, float f) {
        this.elements[this.zero + n * this.stride] = f;
    }

    public void swap(FloatMatrix1D floatMatrix1D) {
        DenseFloatMatrix1D denseFloatMatrix1D;
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D)) {
            super.swap(floatMatrix1D);
        }
        if ((denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D) == this) {
            return;
        }
        this.checkSize(denseFloatMatrix1D);
        final float[] fArray = denseFloatMatrix1D.elements;
        if (this.elements == null || fArray == null) {
            throw new InternalError();
        }
        final int n = (int)floatMatrix1D.index(0);
        final int n2 = floatMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseFloatMatrix1D.this.zero + n5 * DenseFloatMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            float f = DenseFloatMatrix1D.this.elements[n3];
                            DenseFloatMatrix1D.this.elements[n3] = fArray[n22];
                            fArray[n22] = f;
                            n3 += DenseFloatMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                float f = this.elements[n7];
                this.elements[n7] = fArray[n8];
                fArray[n8] = f;
                n7 += this.stride;
                n8 += n2;
            }
        }
    }

    public void toArray(float[] fArray) {
        if (fArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, fArray, 0, this.elements.length);
        } else {
            super.toArray(fArray);
        }
    }

    public float zDotProduct(FloatMatrix1D floatMatrix1D, int n, int n2) {
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D)) {
            return super.zDotProduct(floatMatrix1D, n, n2);
        }
        DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D;
        int n3 = n + n2;
        if (n < 0 || n2 < 0) {
            return 0.0f;
        }
        if (this.size < n3) {
            n3 = this.size;
        }
        if (floatMatrix1D.size() < (long)n3) {
            n3 = (int)floatMatrix1D.size();
        }
        final float[] fArray = denseFloatMatrix1D.elements;
        int n4 = (int)this.index(n);
        int n5 = (int)denseFloatMatrix1D.index(n);
        int n6 = denseFloatMatrix1D.stride;
        if (this.elements == null || fArray == null) {
            throw new InternalError();
        }
        float f = 0.0f;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n8;
            final int n9 = n4;
            final int n10 = n5;
            final int n11 = n6;
            n7 = Math.min(n7, n2);
            Future[] futureArray = new Future[n7];
            Float[] floatArray = new Float[n7];
            int n12 = n2 / n7;
            for (n8 = 0; n8 < n7; ++n8) {
                final int n13 = n8 * n12;
                final int n14 = n8 == n7 - 1 ? n2 : n13 + n12;
                futureArray[n8] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int n = n9 + n13 * DenseFloatMatrix1D.this.stride;
                        int n2 = n10 + n13 * n11;
                        n -= DenseFloatMatrix1D.this.stride;
                        n2 -= n11;
                        float f = 0.0f;
                        int n3 = n14 - n13;
                        int n4 = n3 / 4;
                        while (--n4 >= 0) {
                            int n5 = n + DenseFloatMatrix1D.this.stride;
                            n = n5;
                            int n6 = n2 + n11;
                            n2 = n6;
                            int n7 = n + DenseFloatMatrix1D.this.stride;
                            n = n7;
                            int n8 = n2 + n11;
                            n2 = n8;
                            n = n + DenseFloatMatrix1D.this.stride;
                            n2 = n2 + n11;
                            f += DenseFloatMatrix1D.this.elements[n5] * fArray[n6] + DenseFloatMatrix1D.this.elements[n7] * fArray[n8] + DenseFloatMatrix1D.this.elements[n] * fArray[n2] + DenseFloatMatrix1D.this.elements[n += DenseFloatMatrix1D.this.stride] * fArray[n2 += n11];
                        }
                        n4 = n3 % 4;
                        while (--n4 >= 0) {
                            f += DenseFloatMatrix1D.this.elements[n += DenseFloatMatrix1D.this.stride] * fArray[n2 += n11];
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            try {
                for (n8 = 0; n8 < n7; ++n8) {
                    floatArray[n8] = (Float)futureArray[n8].get();
                }
                f = floatArray[0].floatValue();
                for (n8 = 1; n8 < n7; ++n8) {
                    f += floatArray[n8].floatValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 -= this.stride;
            n5 -= n6;
            int n15 = n3 - n;
            int n16 = n15 / 4;
            while (--n16 >= 0) {
                int n17 = n4 + this.stride;
                n4 = n17;
                int n18 = n5 + n6;
                n5 = n18;
                int n19 = n4 + this.stride;
                n4 = n19;
                int n20 = n5 + n6;
                n5 = n20;
                n4 = n4 + this.stride;
                n5 = n5 + n6;
                f += this.elements[n17] * fArray[n18] + this.elements[n19] * fArray[n20] + this.elements[n4] * fArray[n5] + this.elements[n4 += this.stride] * fArray[n5 += n6];
            }
            n16 = n15 % 4;
            while (--n16 >= 0) {
                f += this.elements[n4 += this.stride] * fArray[n5 += n6];
            }
        }
        return f;
    }

    public float zSum() {
        float f = 0.0f;
        final float[] fArray = this.elements;
        if (fArray == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n2;
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            Float[] floatArray = new Float[n];
            int n3 = this.size / n;
            for (n2 = 0; n2 < n; ++n2) {
                final int n4 = n2 * n3;
                final int n5 = n2 == n - 1 ? this.size : n4 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float f = 0.0f;
                        int n = DenseFloatMatrix1D.this.zero + n4 * DenseFloatMatrix1D.this.stride;
                        for (int i = n4; i < n5; ++i) {
                            f += fArray[n];
                            n += DenseFloatMatrix1D.this.stride;
                        }
                        return Float.valueOf(f);
                    }
                });
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    floatArray[n2] = (Float)futureArray[n2].get();
                }
                f = floatArray[0].floatValue();
                for (n2 = 1; n2 < n; ++n2) {
                    f += floatArray[n2].floatValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n6 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                f += fArray[n6];
                n6 += this.stride;
            }
        }
        return f;
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.zero;
        float[] fArray = this.elements;
        int n4 = this.size;
        while (--n4 >= 0 && n2 < n) {
            if (fArray[n3] != 0.0f) {
                ++n2;
            }
            n3 += this.stride;
        }
        return n2;
    }

    protected boolean haveSharedCellsRaw(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D instanceof SelectedDenseFloatMatrix1D) {
            SelectedDenseFloatMatrix1D selectedDenseFloatMatrix1D = (SelectedDenseFloatMatrix1D)floatMatrix1D;
            return this.elements == selectedDenseFloatMatrix1D.elements;
        }
        if (floatMatrix1D instanceof DenseFloatMatrix1D) {
            DenseFloatMatrix1D denseFloatMatrix1D = (DenseFloatMatrix1D)floatMatrix1D;
            return this.elements == denseFloatMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return this.zero + n * this.stride;
    }

    protected FloatMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseFloatMatrix1D(this.elements, nArray);
    }
}

