/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2DProcedure;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleFactory3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import junit.framework.TestCase;

public abstract class DComplexMatrix3DTest
extends TestCase {
    protected DComplexMatrix3D A;
    protected DComplexMatrix3D B;
    protected int NSLICES = 5;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected double TOL = 1.0E-10;

    public DComplexMatrix3DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        int n3;
        ConcurrencyUtils.setThreadsBeginN_3D(1);
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < this.A.columns(); ++n) {
                    this.A.setQuick(n3, n2, n, new double[]{Math.random(), Math.random()});
                }
            }
        }
        for (n3 = 0; n3 < this.B.slices(); ++n3) {
            for (n2 = 0; n2 < this.B.rows(); ++n2) {
                for (n = 0; n < this.B.columns(); ++n) {
                    this.B.setQuick(n3, n2, n, new double[]{Math.random(), Math.random()});
                }
            }
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    protected void assertEquals(double[] dArray, double[] dArray2, double d) {
        for (int i = 0; i < dArray2.length; ++i) {
            DComplexMatrix3DTest.assertEquals((double)dArray[i], (double)dArray2[i], (double)d);
        }
    }

    public void testAggregateComplexComplexComplexFunctionComplexComplexFunction() {
        double[] dArray = this.A.aggregate(DComplexFunctions.plus, DComplexFunctions.sqrt);
        double[] dArray2 = new double[2];
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    dArray2 = DComplex.plus(dArray2, DComplex.sqrt(this.A.getQuick(i, j, k)));
                }
            }
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    public void testAggregateComplexMatrix3DComplexComplexComplexFunctionComplexComplexComplexFunction() {
        double[] dArray = this.A.aggregate(this.B, DComplexFunctions.plus, DComplexFunctions.mult);
        double[] dArray2 = new double[2];
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    dArray2 = DComplex.plus(dArray2, DComplex.mult(this.A.getQuick(i, j, k), this.B.getQuick(i, j, k)));
                }
            }
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    public void testAssignComplexComplexFunction() {
        DComplexMatrix3D dComplexMatrix3D = this.A.copy();
        this.A.assign(DComplexFunctions.acos);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(DComplex.acos(dComplexMatrix3D.getQuick(i, j, k)), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexMatrix3D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.B.getQuick(i, j, k), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexMatrix3DComplexComplexComplexFunction() {
        DComplexMatrix3D dComplexMatrix3D = this.A.copy();
        this.A.assign(this.B, DComplexFunctions.div);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(DComplex.div(dComplexMatrix3D.getQuick(i, j, k), this.B.getQuick(i, j, k)), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexProcedureComplexComplexFunction() {
        DComplexMatrix3D dComplexMatrix3D = this.A.copy();
        this.A.assign(new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 3.0;
            }
        }, DComplexFunctions.tan);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (DComplex.abs(dComplexMatrix3D.getQuick(i, j, k)) > 3.0) {
                        DComplexMatrix3DTest.assertEquals((double)DComplex.abs(dComplexMatrix3D.getQuick(i, j, k)), (double)this.A.getQuick(i, j, k)[0], (double)this.TOL);
                        DComplexMatrix3DTest.assertEquals((double)0.0, (double)this.A.getQuick(i, j, k)[1], (double)this.TOL);
                        continue;
                    }
                    this.assertEquals(dComplexMatrix3D.getQuick(i, j, k), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexProcedureDoubleArray() {
        DComplexMatrix3D dComplexMatrix3D = this.A.copy();
        double[] dArray = new double[]{Math.random(), Math.random()};
        this.A.assign(new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 3.0;
            }
        }, dArray);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (DComplex.abs(dComplexMatrix3D.getQuick(i, j, k)) > 3.0) {
                        this.assertEquals(dArray, this.A.getQuick(i, j, k), this.TOL);
                        continue;
                    }
                    this.assertEquals(dComplexMatrix3D.getQuick(i, j, k), this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignComplexRealFunction() {
        DComplexMatrix3D dComplexMatrix3D = this.A.copy();
        this.A.assign(DComplexFunctions.abs);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DComplexMatrix3DTest.assertEquals((double)DComplex.abs(this.A.getQuick(i, j, k)), (double)this.A.getQuick(i, j, k)[0], (double)this.TOL);
                    DComplexMatrix3DTest.assertEquals((double)0.0, (double)this.A.getQuick(i, j, k)[1], (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleArray() {
        double[] dArray = new double[2 * (int)this.A.size()];
        int n = 0;
        while ((long)n < 2L * this.A.size()) {
            dArray[n] = Math.random();
            ++n;
        }
        this.A.assign(dArray);
        n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DComplexMatrix3DTest.assertEquals((double)dArray[n], (double)this.A.getQuick(i, j, k)[0], (double)this.TOL);
                    DComplexMatrix3DTest.assertEquals((double)dArray[n + 1], (double)this.A.getQuick(i, j, k)[1], (double)this.TOL);
                    n += 2;
                }
            }
        }
    }

    public void testAssignDoubleArrayArrayArray() {
        int n;
        int n2;
        int n3;
        double[][][] dArray = new double[this.A.slices()][this.A.rows()][2 * this.A.columns()];
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < 2 * this.A.columns(); ++n) {
                    dArray[n3][n2][n] = Math.random();
                }
            }
        }
        this.A.assign(dArray);
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            DComplexMatrix3DTest.assertTrue((this.A.rows() == dArray[n3].length ? 1 : 0) != 0);
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                DComplexMatrix3DTest.assertTrue((2 * this.A.columns() == dArray[n3][n2].length ? 1 : 0) != 0);
                for (n = 0; n < this.A.columns(); ++n) {
                    DComplexMatrix3DTest.assertEquals((double)dArray[n3][n2][2 * n], (double)this.A.getQuick(n3, n2, n)[0], (double)this.TOL);
                    DComplexMatrix3DTest.assertEquals((double)dArray[n3][n2][2 * n + 1], (double)this.A.getQuick(n3, n2, n)[1], (double)this.TOL);
                }
            }
        }
    }

    public void testAssignDoubleDouble() {
        double[] dArray = new double[]{Math.random(), Math.random()};
        this.A.assign(dArray[0], dArray[1]);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(dArray, this.A.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testAssignImaginary() {
        DComplexMatrix3D dComplexMatrix3D = this.A.copy();
        DoubleMatrix3D doubleMatrix3D = DoubleFactory3D.dense.random(this.A.slices(), this.A.rows(), this.A.columns());
        this.A.assignImaginary(doubleMatrix3D);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DComplexMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k)[1], (double)this.TOL);
                    DComplexMatrix3DTest.assertEquals((double)dComplexMatrix3D.getQuick(i, j, k)[0], (double)this.A.getQuick(i, j, k)[0], (double)this.TOL);
                }
            }
        }
    }

    public void testAssignReal() {
        DComplexMatrix3D dComplexMatrix3D = this.A.copy();
        DoubleMatrix3D doubleMatrix3D = DoubleFactory3D.dense.random(this.A.slices(), this.A.rows(), this.A.columns());
        this.A.assignReal(doubleMatrix3D);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DComplexMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k)[0], (double)this.TOL);
                    DComplexMatrix3DTest.assertEquals((double)dComplexMatrix3D.getQuick(i, j, k)[1], (double)this.A.getQuick(i, j, k)[1], (double)this.TOL);
                }
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)n);
    }

    public void testEqualsDoubleArray() {
        double[] dArray = new double[]{Math.random(), Math.random()};
        this.A.assign(dArray[0], dArray[1]);
        boolean bl = this.A.equals(dArray);
        DComplexMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(new double[]{dArray[0] + 1.0, dArray[1] + 1.0});
        DComplexMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        DComplexMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        DComplexMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testGetImaginaryPart() {
        DoubleMatrix3D doubleMatrix3D = this.A.getImaginaryPart();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DComplexMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k)[1], (double)doubleMatrix3D.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testGetRealPart() {
        DoubleMatrix3D doubleMatrix3D = this.A.getRealPart();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DComplexMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k)[0], (double)doubleMatrix3D.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testGetNonZeros() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        this.A.getNonZeros(intArrayList, intArrayList2, intArrayList3, arrayList);
        DComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)intArrayList.size());
        DComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)intArrayList2.size());
        DComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)intArrayList3.size());
        DComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)arrayList.size());
        int n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(intArrayList.get(n), intArrayList2.get(n), intArrayList3.get(n)), arrayList.get(n), this.TOL);
                    ++n;
                }
            }
        }
    }

    public void testToArray() {
        double[][][] dArray = this.A.toArray();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DComplexMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k)[0], (double)dArray[i][j][2 * k], (double)this.TOL);
                    DComplexMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k)[1], (double)dArray[i][j][2 * k + 1], (double)this.TOL);
                }
            }
        }
    }

    public void testVectorize() {
        DComplexMatrix1D dComplexMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                for (int k = 0; k < this.A.rows(); ++k) {
                    this.assertEquals(this.A.getQuick(i, k, j), dComplexMatrix1D.getQuick(n++), this.TOL);
                }
            }
        }
    }

    public void testViewColumn() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewColumn(this.A.columns() / 2);
        DComplexMatrix3DTest.assertEquals((int)this.A.slices(), (int)dComplexMatrix2D.rows());
        DComplexMatrix3DTest.assertEquals((int)this.A.rows(), (int)dComplexMatrix2D.columns());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                this.assertEquals(this.A.getQuick(i, j, this.A.columns() / 2), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewColumnFlip() {
        DComplexMatrix3D dComplexMatrix3D = this.A.viewColumnFlip();
        DComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)dComplexMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(i, j, this.A.columns() - 1 - k), dComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewDice() {
        DComplexMatrix3D dComplexMatrix3D = this.A.viewDice(2, 1, 0);
        DComplexMatrix3DTest.assertEquals((int)this.A.slices(), (int)dComplexMatrix3D.columns());
        DComplexMatrix3DTest.assertEquals((int)this.A.rows(), (int)dComplexMatrix3D.rows());
        DComplexMatrix3DTest.assertEquals((int)this.A.columns(), (int)dComplexMatrix3D.slices());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(i, j, k), dComplexMatrix3D.getQuick(k, j, i), this.TOL);
                }
            }
        }
    }

    public void testViewPart() {
        DComplexMatrix3D dComplexMatrix3D = this.A.viewPart(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3);
        for (int i = 0; i < this.A.slices() / 3; ++i) {
            for (int j = 0; j < this.A.rows() / 3; ++j) {
                for (int k = 0; k < this.A.columns() / 3; ++k) {
                    this.assertEquals(this.A.getQuick(this.A.slices() / 2 + i, this.A.rows() / 2 + j, this.A.columns() / 2 + k), dComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewRow() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewRow(this.A.rows() / 2);
        DComplexMatrix3DTest.assertEquals((int)this.A.slices(), (int)dComplexMatrix2D.rows());
        DComplexMatrix3DTest.assertEquals((int)this.A.columns(), (int)dComplexMatrix2D.columns());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(this.A.getQuick(i, this.A.rows() / 2, j), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewRowFlip() {
        DComplexMatrix3D dComplexMatrix3D = this.A.viewRowFlip();
        DComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)dComplexMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(i, this.A.rows() - 1 - j, k), dComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewSelectionComplexMatrix2DProcedure() {
        final double[] dArray = new double[]{2.0, 3.0};
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 2, 0, dArray);
        DComplexMatrix3D dComplexMatrix3D = this.A.viewSelection(new DComplexMatrix2DProcedure(){

            public boolean apply(DComplexMatrix2D dComplexMatrix2D) {
                return DComplex.isEqual(dComplexMatrix2D.getQuick(DComplexMatrix3DTest.this.A.rows() / 2, 0), dArray, DComplexMatrix3DTest.this.TOL);
            }
        });
        DComplexMatrix3DTest.assertEquals((int)1, (int)dComplexMatrix3D.slices());
        DComplexMatrix3DTest.assertEquals((int)this.A.rows(), (int)dComplexMatrix3D.rows());
        DComplexMatrix3DTest.assertEquals((int)this.A.columns(), (int)dComplexMatrix3D.columns());
        this.assertEquals(this.A.getQuick(this.A.slices() / 2, this.A.rows() / 2, 0), dComplexMatrix3D.getQuick(0, this.A.rows() / 2, 0), this.TOL);
    }

    public void testViewSelectionIntArrayIntArrayIntArray() {
        int[] nArray = new int[]{this.A.slices() / 2, this.A.slices() / 3};
        int[] nArray2 = new int[]{this.A.rows() / 6, this.A.rows() / 5, this.A.rows() / 4, this.A.rows() / 3, this.A.rows() / 2};
        int[] nArray3 = new int[]{this.A.columns() / 6, this.A.columns() / 5, this.A.columns() / 4, this.A.columns() / 3, this.A.columns() / 2, this.A.columns() - 1};
        DComplexMatrix3D dComplexMatrix3D = this.A.viewSelection(nArray, nArray2, nArray3);
        DComplexMatrix3DTest.assertEquals((int)nArray.length, (int)dComplexMatrix3D.slices());
        DComplexMatrix3DTest.assertEquals((int)nArray2.length, (int)dComplexMatrix3D.rows());
        DComplexMatrix3DTest.assertEquals((int)nArray3.length, (int)dComplexMatrix3D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                for (int k = 0; k < nArray3.length; ++k) {
                    this.assertEquals(this.A.getQuick(nArray[i], nArray2[j], nArray3[k]), dComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewSlice() {
        DComplexMatrix2D dComplexMatrix2D = this.A.viewSlice(this.A.slices() / 2);
        DComplexMatrix3DTest.assertEquals((int)this.A.rows(), (int)dComplexMatrix2D.rows());
        DComplexMatrix3DTest.assertEquals((int)this.A.columns(), (int)dComplexMatrix2D.columns());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                this.assertEquals(this.A.getQuick(this.A.slices() / 2, i, j), dComplexMatrix2D.getQuick(i, j), this.TOL);
            }
        }
    }

    public void testViewSliceFlip() {
        DComplexMatrix3D dComplexMatrix3D = this.A.viewSliceFlip();
        DComplexMatrix3DTest.assertEquals((long)this.A.size(), (long)dComplexMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(this.A.slices() - 1 - i, j, k), dComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testViewStrides() {
        int n = 2;
        int n2 = 2;
        int n3 = 2;
        DComplexMatrix3D dComplexMatrix3D = this.A.viewStrides(n, n2, n3);
        for (int i = 0; i < dComplexMatrix3D.slices(); ++i) {
            for (int j = 0; j < dComplexMatrix3D.rows(); ++j) {
                for (int k = 0; k < dComplexMatrix3D.columns(); ++k) {
                    this.assertEquals(this.A.getQuick(i * n, j * n2, k * n3), dComplexMatrix3D.getQuick(i, j, k), this.TOL);
                }
            }
        }
    }

    public void testZSum() {
        double[] dArray = this.A.zSum();
        double[] dArray2 = new double[2];
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    dArray2 = DComplex.plus(dArray2, this.A.getQuick(i, j, k));
                }
            }
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }
}

