% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupplot.r
\name{stackplot}
\alias{stackplot}
\title{plot grouped CSMF from a "insilico" object}
\usage{
stackplot(
  x,
  grouping = NULL,
  type = c("stack", "dodge")[1],
  order.group = NULL,
  order.sub = NULL,
  err = TRUE,
  CI = 0.95,
  sample.size.print = FALSE,
  xlab = "Group",
  ylab = "CSMF",
  ylim = NULL,
  title = "CSMF by broader cause categories",
  horiz = FALSE,
  angle = 60,
  err_width = 0.4,
  err_size = 0.6,
  point_size = 2,
  border = "black",
  bw = FALSE,
  ...
)
}
\arguments{
\item{x}{fitted \code{"insilico"} object}

\item{grouping}{C by 2 matrix of grouping rule. If set to NULL, make it default.}

\item{type}{type of the plot to make}

\item{order.group}{list of grouped categories. If set to NULL, make it default.}

\item{order.sub}{Specification of the order of sub-populations to plot}

\item{err}{indicator of inclusion of error bars}

\item{CI}{confidence interval for error bars.}

\item{sample.size.print}{Logical indicator for printing also the sample size for each sub-population labels.}

\item{xlab}{Labels for the causes.}

\item{ylab}{Labels for the CSMF values.}

\item{ylim}{Range of y-axis.}

\item{title}{Title of the plot.}

\item{horiz}{Logical indicator indicating if the bars are plotted
horizontally.}

\item{angle}{Angle of rotation for the texts on x axis when \code{horiz} is
set to FALSE}

\item{err_width}{Size of the error bars.}

\item{err_size}{Thickness of the error bar lines.}

\item{point_size}{Size of the points.}

\item{border}{The color for the border of the bars.}

\item{bw}{Logical indicator for setting the theme of the plots to be black
and white.}

\item{\dots}{Not used.}
}
\description{
Produce bar plot of the CSMFs for a fitted \code{"insilico"} object in broader groups.
}
\examples{
\dontrun{
  data(RandomVA1) 
  ##
  ## Scenario 1: without sub-population specification
  ##
  fit1<- insilico(RandomVA1, subpop = NULL,  
                Nsim = 1000, burnin = 500, thin = 10 , seed = 1,
                auto.length = FALSE)
  # stack bar plot for grouped causes
  # the default grouping could be seen from
  data(SampleCategory)
  stackplot(fit1, type = "dodge", xlab = "")
  
  ##
  ## Scenario 2: with sub-population specification
  ##
  data(RandomVA2)
  fit2<- insilico(RandomVA2, subpop = list("sex"),  
                Nsim = 1000, burnin = 500, thin = 10 , seed = 1,
                auto.length = FALSE)
  stackplot(fit2, type = "stack", angle = 0)
  stackplot(fit2, type = "dodge", angle = 0)
  # Change the default grouping by separating TB from HIV
  data(SampleCategory)
  SampleCategory[c(3, 9), ]
  SampleCategory[3, 2] <- "HIV/AIDS"
  SampleCategory[9, 2] <- "TB"
  stackplot(fit2, type = "stack", grouping = SampleCategory, 
            sample.size.print = TRUE, angle = 0)
  stackplot(fit2, type = "dodge", grouping = SampleCategory,
            sample.size.print = TRUE, angle = 0)
  
  # change the order of display for sub-population and cause groups
  groups <- c("HIV/AIDS", "TB", "Communicable", "NCD", "External",
              "Maternal", "causes specific to infancy") 
  subpops <- c("Women", "Men")
  stackplot(fit2, type = "stack", grouping = SampleCategory, 
            order.group = groups, order.sub = subpops, 
            sample.size.print = TRUE, angle = 0)	
} 
}
\references{
Tyler H. McCormick, Zehang R. Li, Clara Calvert, Amelia C. Crampin,
Kathleen Kahn and Samuel J. Clark Probabilistic cause-of-death assignment
using verbal autopsies, \emph{Journal of the American Statistical
Association} (2016), 111(515):1036-1049.
}
\seealso{
\code{\link{insilico}}, \code{\link{summary.insilico}}
}
\author{
Zehang Li, Tyler McCormick, Sam Clark

Maintainer: Zehang Li <lizehang@uw.edu>
}
\keyword{InSilicoVA}
