% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_aggregation_MPI.R
\name{linear_aggregation_MPI}
\alias{linear_aggregation_MPI}
\title{Mazziotta-Pareto index}
\usage{
linear_aggregation_MPI(data, pol = "pos")
}
\arguments{
\item{data}{dataframe with rows = observations and columns = quantitative}

\item{pol}{polarity if not selected is positive, otherwise write neg (see
details)}
}
\value{
It returns a dataframe with rows = observations and column =
composite indicator
}
\description{
The Mazziotta–Pareto index (MPI) is a composite index for summarizing a set
of individual indicators that are assumed to be not fully substitutable. It
is based on a non-linear function which, starting from the arithmetic mean
of the normalized indicators, introduces a penalty for the units with
unbalanced values of the indicators
}
\details{
The ‘polarity’ of an indicator is the sign of the relation between the
indicator and the phenomenon to be measured ( + if the indicator represents
a dimension considered positive and - otherwise)
}
\examples{

data("Education")
Indicator=linear_aggregation_MPI(Education)
print(Indicator)

#----With negative polarity
Indicator_neg=linear_aggregation_MPI(Education,"neg")
print(Indicator_neg)


}
\references{
De Muro P., Mazziotta M., Pareto A. (2011), "Composite Indices
of Development and Poverty: An Application to MDGs", Social Indicators
Research, Volume 104, Number 1, pp. 1-18
}
\keyword{Index}
\keyword{MPI}
\keyword{Mazziotta-Pareto}
