% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntCal.R
\name{mix.ccurves}
\alias{mix.ccurves}
\title{Build a custom-made, mixed calibration curve.}
\usage{
mix.ccurves(
  proportion = 0.5,
  cc1 = "IntCal20",
  cc2 = "Marine20",
  name = "mixed.14C",
  dir = c(),
  offset = c(0, 0),
  sep = "\\t"
)
}
\arguments{
\item{proportion}{Proportion of the first calibration curve required. e.g., change to \code{proportion=0.7} if \code{cc1} should contribute 70\% (and \code{cc2} 30\%) to the mixed curve.}

\item{cc1}{The first calibration curve to be mixed. Defaults to the northern hemisphere terrestrial curve IntCal20.}

\item{cc2}{The second calibration curve to be mixed. Defaults to the marine curve IntCal20.}

\item{name}{Name of the new calibration curve.}

\item{dir}{Name of the directory where to save the file. Since R does not allow automatic saving of files, this points to a temporary directory by default. Adapt to your own folder, e.g., \code{dir="~/Curves"} or in your current working directory, \code{dir="."}.}

\item{offset}{Any offset and error to be applied to \code{cc2} (default 0 +- 0).}

\item{sep}{Separator between fields (tab by default, "\\t")}
}
\value{
A file containing the custom-made calibration curve, based on calibration curves \code{cc1} and \code{cc2}.
}
\description{
If two curves need to be `mixed' to calibrate, e.g. for dates of mixed terrestrial and marine carbon sources, then this function can be used. The curve will be saved, together with the main calibration curves, in a temporary directory. This temporary directory then has to be specified in further commands, e.g. for rbacon: \code{Bacon(, ccdir=tmpdr)} (see examples). It is advisable to make your own curves folder and have ccdir point to that folder.
}
\details{
The proportional contribution of each of both calibration curves has to be set.
}
\examples{
mix.ccurves()
tmpdir <- tempdir()
mix.ccurves(dir=tmpdir)
# clean up:
unlink(tmpdir)
}
