% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{EHC}
\alias{EHC}
\title{Ensemble for hierarchical clustering}
\usage{
EHC(List, type = c("data", "dist", "clust"), distmeasure = c("tanimoto",
  "tanimoto"), normalize = c(FALSE, FALSE), method = c(NULL, NULL),
  clust = "agnes", linkage = c("flexible", "flexible"), alpha = 0.625,
  gap = FALSE, maxK = 15, graphPartitioning = c("METIS", "MST"),
  optimalk = 7, waitingtime = 300, file_number = 0, executable = FALSE)
}
\arguments{
\item{List}{A list of data matrices. It is assumed the rows are corresponding with the objects.}

\item{type}{indicates whether the provided matrices in "List" are either data matrices, distance
matrices or clustering results obtained from the data. If type="dist" the calculation of the distance
matrices is skipped and if type="clusters" the single source clustering is skipped.
Type should be one of "data", "dist" or"clusters".}

\item{distmeasure}{A vector of the distance measures to be used on each data matrix. Should be one of "tanimoto", "euclidean", "jaccard", "hamming". Defaults to c("tanimoto","tanimoto").}

\item{normalize}{Logical. Indicates whether to normalize the distance matrices or not, default is FALSE. This is recommended if different distance types are used. More details on normalization in \code{Normalization}}

\item{method}{A method of normalization. Should be one of "Quantile","Fisher-Yates", "standardize","Range" or any of the first letters of these names. Default is c(NULL,NULL) for two data sets.}

\item{clust}{Choice of clustering function (character). Defaults to "agnes".}

\item{linkage}{Choice of inter group dissimilarity (character) for each data set. Defaults to c("flexible", "flexible") for two data sets.}

\item{alpha}{The parameter alpha to be used in the "flexible" linkage of the agnes function. Defaults to 0.625 and is only used if the linkage is set to "flexible"}

\item{gap}{Logical. Whether the optimal number of clusters should be determined with the gap statistic. Defaults to FALSE.}

\item{maxK}{The maximal number of clusters to investigate in the gap statistic. Default is 15.}

\item{graphPartitioning}{The graph-partitioning method to be performed: "METIS" (implemented in MATLAB), "MST".}

\item{optimalk}{An estimate of the final optimal number of clusters. Default is 7.}

\item{waitingtime}{The time in seconds to wait until the MATLAB results are generated. Defaults to 300.}

\item{file_number}{The specific file number to be placed as a tag in the file generated by MATLAB. Defaults to 00.}

\item{executable}{Logical. Whether the METIS MATLAB function is performed via an executable on the command line (TRUE, only possible for Linux systems) or by calling on MATLAB directly (FALSE). Defaults to FALSE.}
}
\value{
The returned value is a list of two elements:
\item{DistM}{The resulting distance matrix}
\item{Clust}{The resulting clusters}
The value has class 'Ensemble'.
}
\description{
The Ensemble for Hierarchical Clustering (EHC, \insertCite{Hossain2012}{IntClust}) defines the strength of association between a 
pair of objects as a measure of how closely these are associated taking into account the levels of the dendrogram. Therefore, the sum of the 
normalized depths of the clusters in which both objects reside is taken as a measure of association. The depths are weighted by the intra-cluster 
proximity values. The resulting similarity matrix is seen as an adjacency matrix of a graph and the METIS algorithm is performed to cut the graph 
in $k$ clusters.
}
\examples{
\dontrun{
data(fingerprintMat)
data(targetMat)
L=list(fingerprintMat,targetMat)

MCF7_EHC=EHC(List=L,type="data",distmeasure=c("tanimoto", "tanimoto"),normalize=
c(FALSE,FALSE),method=c(NULL,NULL),clust="agnes",linkage = c("flexible","flexible"),
alpha=0.625,gap=FALSE,maxK=15,graphPartitioning="METIS",optimalk=7,
waitingtime=300,file_number=00,executable=FALSE)

}
}
\references{
\insertRef{Hossain2012}{IntClust}
}
