% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterVA5.plot.R
\name{COMCAT.interVA5}
\alias{COMCAT.interVA5}
\title{Summarize population level mortality fraction by Circumstance of Mortality Category}
\usage{
COMCAT.interVA5(va)
}
\arguments{
\item{va}{The list of va object to summarize.}
}
\value{
\item{dist.cod}{The cause-specific mortality fraction (including undetermined category).}
}
\description{
The function takes input of a list of va object and calculates the
mortality fraction by Circumstance of Mortality Category.
}
\examples{

data(SampleInputV5)
sample.output <- InterVA5(SampleInputV5, HIV = "h", Malaria = "v", 
       write=TRUE, directory = tempdir(),
       filename = "VA5_result", output = "extended", append = FALSE)
## Get CSMF without plots
comcat <- COMCAT.interVA5(sample.output$VA5)

}
\seealso{
\code{\link{CSMF5}}
}
\author{
Jason Thomas, Zehang LI, Tyler McCormick, Sam Clark
}
\keyword{interVA}
