% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\name{I.R}
\alias{I.R}
\title{Isotopic ratios}
\usage{
I.R(ratio, x = NULL, e = NULL)
}
\arguments{
\item{ratio}{one of either \code{'U238U235'}, \code{'Ar40Ar36'},
\code{'Ar38Ar36'}, \code{'Rb85Rb87'}, \code{'Sr88Sr86'},
\code{'Sr87Sr86'}, \code{'Sr84Sr86'}, \code{'Re185Re187'},
\code{'Os184Os192'}, \code{'Os186Os192'}, \code{'Os187Os192'},
\code{'Os188Os192'}, \code{'Os189Os192'}}

\item{x}{new value for ratio}

\item{e}{new value for its standard error}
}
\value{
if x == e == NULL, returns a two-item vector containing the
    mean value of the requested ratio and its standard error,
    respectively.
}
\description{
Gets or sets natural isotopic ratios.
}
\examples{
# returns the 238U/235U ratio of Hiess et al. (2012):
print(I.R('U238U235'))
# use the 238U/235U ratio of Steiger and Jaeger (1977):
I.R('U238U235',138.88,0)
print(I.R('U238U235'))
}
\references{
Ar: Lee, Jee-Yon, et al. "A redetermination of the isotopic abundances
of atmospheric Ar." Geochimica et Cosmochimica Acta 70.17 (2006): 4507-4512.

Rb: Catanzaro, E. J., et al. "Absolute isotopic abundance ratio and
atomic weight of terrestrial rubidium." J. Res. Natl. Bur. Stand. A 73
(1969): 511-516.

Sr: Moore, L. J., et al. "Absolute isotopic abundance ratios and atomic
weight of a reference sample of strontium." J. Res. Natl.Bur. Stand.
87.1 (1982): 1-8.

Re: Gramlich, John W., et al. "Absolute isotopic abundance ratio and
atomic weight of a reference sample of rhenium." J. Res. Natl. Bur.
Stand. A 77 (1973): 691-698.

Os: Voelkening, Joachim, Thomas Walczyk, and Klaus G. Heumann.
"Osmium isotope ratio determinations by negative thermal ionization
mass spectrometry." Int. J. Mass Spect. Ion Proc. 105.2 (1991): 147-159.

U: Hiess, Joe, et al. "238U/235U systematics in terrestrial
uranium-bearing minerals." Science 335.6076 (2012): 1610-1614.
}

