% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochron.R
\name{isochron}
\alias{isochron}
\alias{isochron.default}
\alias{isochron.UPb}
\alias{isochron.PbPb}
\alias{isochron.ArAr}
\alias{isochron.ThPb}
\alias{isochron.KCa}
\alias{isochron.RbSr}
\alias{isochron.ReOs}
\alias{isochron.SmNd}
\alias{isochron.LuHf}
\alias{isochron.ThU}
\alias{isochron.UThHe}
\title{Calculate and plot isochrons}
\usage{
isochron(x, ...)

\method{isochron}{default}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  xlab = "x",
  ylab = "y",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  title = TRUE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{UPb}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  joint = TRUE,
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  type = 1,
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = FALSE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  anchor = 0,
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{PbPb}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  inverse = TRUE,
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = TRUE,
  model = 1,
  growth = FALSE,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{ArAr}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  inverse = TRUE,
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = TRUE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{ThPb}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  inverse = FALSE,
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = TRUE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{KCa}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  inverse = FALSE,
  ci.col = "gray80",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = TRUE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{RbSr}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  inverse = FALSE,
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = TRUE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{ReOs}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  inverse = FALSE,
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = TRUE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{SmNd}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  inverse = FALSE,
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = TRUE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{LuHf}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  inverse = FALSE,
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = TRUE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{ThU}(
  x,
  type = 2,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  exterr = TRUE,
  model = 1,
  show.ellipses = 1 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)

\method{isochron}{UThHe}(
  x,
  alpha = 0.05,
  sigdig = 2,
  show.numbers = FALSE,
  levels = NA,
  clabel = "",
  ellipse.fill = c("#00FF0080", "#FF000080"),
  ellipse.stroke = "black",
  ci.col = "gray80",
  line.col = "black",
  lwd = 1,
  plot = TRUE,
  model = 1,
  show.ellipses = 2 * (model != 2),
  hide = NULL,
  omit = NULL,
  omit.fill = NA,
  omit.stroke = "grey",
  ...
)
}
\arguments{
\item{x}{EITHER a matrix with the following five columns:

\code{X}: the x-variable

\code{sX}: the standard error of \code{X}

\code{Y}: the y-variable

\code{sY}: the standard error of \code{Y}

\code{rXY}: the correlation coefficient of \code{X} and \code{Y}

OR

an object of class \code{ArAr}, \code{KCa}, \code{PbPb},
\code{UPb}, \code{ThPb}, \code{ReOs}, \code{RbSr}, \code{SmNd},
\code{LuHf}, \code{UThHe} or \code{ThU}.}

\item{...}{optional arguments to be passed on to the generic plot
function if \code{model=2}}

\item{alpha}{confidence cutoff for the error ellipses and
confidence intervals}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output}

\item{show.numbers}{logical flag (\code{TRUE} to show grain numbers)}

\item{levels}{a vector with additional values to be displayed as
different background colours within the error ellipses.}

\item{clabel}{label for the colour scale}

\item{xlab}{text label for the horizontal plot axis}

\item{ylab}{text label for the vertical plot axis}

\item{ellipse.fill}{Fill colour for the error ellipses. This can either be a single
colour or multiple colours to form a colour ramp. Examples:

a single colour: \code{rgb(0,1,0,0.5)}, \code{'#FF000080'},
\code{'white'}, etc.;

multiple colours: \code{c(rbg(1,0,0,0.5)},
\code{rgb(0,1,0,0.5))}, \code{c('#FF000080','#00FF0080')},
\code{c('blue','red')}, \code{c('blue','yellow','red')}, etc.;

a colour palette: \code{rainbow(n=100)},
\code{topo.colors(n=100,alpha=0.5)}, etc.; or

a reversed palette: \code{rev(topo.colors(n=100,alpha=0.5))},
etc.

For empty ellipses, set \code{ellipse.col=NA}}

\item{ellipse.stroke}{the stroke colour for the error
ellipses. Follows the same formatting guidelines as
\code{ellipse.fill}}

\item{ci.col}{the fill colour for the confidence interval of the
intercept and slope.}

\item{line.col}{colour of the isochron line}

\item{lwd}{line width}

\item{plot}{if \code{FALSE}, suppresses the graphical output}

\item{title}{add a title to the plot?}

\item{model}{construct the isochron using either:

\code{1}: Error-weighted least squares regression

\code{2}: Ordinary least squares regression

\code{3}: Error-weighted least squares with overdispersion term}

\item{show.ellipses}{show the data as:

\code{0}: points

\code{1}: error ellipses

\code{2}: error crosses}

\item{hide}{vector with indices of aliquots that should be removed
from the plot.}

\item{omit}{vector with indices of aliquots that should be plotted
but omitted from the isochron age calculation.}

\item{omit.fill}{fill colour that should be used for the omitted
aliquots.}

\item{omit.stroke}{stroke colour that should be used for the
omitted aliquots.}

\item{joint}{logical. Only applies to U-Pb data formats 4 and above. If
\code{TRUE}, carries out three dimensional regression.  If
\code{FALSE}, uses two dimensional isochron regression.  The latter
can be used to compute \eqn{{}^{207}}Pb/\eqn{{}^{235}}U isochrons,
which are immune to the complexities of initial
\eqn{{}^{234}}U/\eqn{{}^{238}}U disequilibrium.}

\item{type}{if \code{x} has class \code{UPb} and \code{x$format=4}, \code{5} or 
\code{6}:

\code{1}: \eqn{^{204}}Pb/\eqn{^{206}}Pb vs. \eqn{^{238}}U/\eqn{^{206}}Pb

\code{2}: \eqn{^{204}}Pb/\eqn{^{207}}Pb vs. \eqn{^{235}}U/\eqn{^{207}}Pb

if \code{x} has class \code{UPb} and \code{x$format=7} or \code{8}:

\code{1}: \eqn{^{208}}Pb\eqn{{}_\circ}/\eqn{^{206}}Pb vs. \eqn{^{238}}U/\eqn{^{206}}Pb

\code{2}: \eqn{^{208}}Pb\eqn{{}_\circ}/\eqn{^{207}}Pb vs. \eqn{^{235}}U/\eqn{^{207}}Pb

\code{3}: \eqn{^{206}}Pb\eqn{{}_\circ}/\eqn{^{208}}Pb
vs. \eqn{^{232}}Th/\eqn{^{208}}Pb

\code{4}: \eqn{^{207}}Pb\eqn{{}_\circ}/\eqn{^{208}}Pb
vs. \eqn{^{232}}Th/\eqn{^{208}}Pb

if \code{x} has class \code{ThU}, and following the classification
of Ludwig and Titterington (1994), one of either:

\code{1}: `Rosholt type-II' isochron, setting out
\eqn{^{230}}Th/\eqn{^{232}}Th vs. \eqn{^{238}}U/\eqn{^{232}}Th

\code{2}: `Osmond type-II' isochron, setting out \eqn{^{230}}Th/\eqn{^{238}}U
vs. \eqn{^{232}}Th/\eqn{^{238}}U

\code{3}: `Rosholt type-II' isochron, setting out \eqn{^{234}}U/\eqn{^{232}}Th
vs. \eqn{^{238}}U/\eqn{^{232}}Th

\code{4}: `Osmond type-II' isochron, setting out \eqn{^{234}}U/\eqn{^{238}}U
vs. \eqn{^{232}}Th/\eqn{^{238}}U}

\item{exterr}{propagate external sources of uncertainty
(J, decay constant)?}

\item{anchor}{control parameters to fix the intercept age or common Pb
composition of the isochron fit. This can be a scalar or a vector.

If \code{anchor[1]=0}: do not anchor the isochron.

If \code{anchor[1]=1}: fix the common Pb composition at the values
stored in \code{settings('iratio',...)}.

If \code{anchor[1]=2}: force the isochron line to intersect the
concordia line at an age equal to \code{anchor[2]}.}

\item{inverse}{toggles between normal and inverse isochrons. If the
    isochron plots \code{Y} against \code{X}, and

If \code{inverse=TRUE}, then \code{X} =
\eqn{{}^{204}}Pb/\eqn{{}^{206}}Pb and \code{Y} =
\eqn{{}^{207}}Pb/\eqn{{}^{206}}Pb (if \code{x} has class
\code{PbPb}), or \code{X} = \eqn{{}^{232}}Th/\eqn{{}^{208}}Pb and
\code{Y} = \eqn{{}^{204}}Pb/\eqn{{}^{208}}Pb (if \code{x} has class
\code{ThPb}), or \code{X} = \eqn{{}^{39}}Ar/\eqn{{}^{40}}Ar and
\code{Y} = \eqn{{}^{36}}Ar/\eqn{{}^{40}}Ar (if \code{x} has class
\code{ArAr}), or \code{X} = \eqn{{}^{40}}K/\eqn{{}^{40}}Ca and
\code{Y} = \eqn{{}^{44}}Ca/\eqn{{}^{40}}Ca (if \code{x} has class
\code{KCa}), or \code{X} = \eqn{{}^{87}}Rb/\eqn{{}^{87}}Sr and
\code{Y} = \eqn{{}^{86}}Sr/\eqn{{}^{87}}Sr (if \code{x} has class
\code{RbSr}), or \code{X} = \eqn{{}^{147}}Sm/\eqn{{}^{143}}Nd and
\code{Y} = \eqn{{}^{144}}Nd/\eqn{{}^{143}}Nd (if \code{x} has class
\code{SmNd}), or \code{X} = \eqn{{}^{187}}Re/\eqn{{}^{187}}Os and
\code{Y} = \eqn{{}^{188}}Os/\eqn{{}^{187}}Os (if \code{x} has class
\code{ReOs}), or \code{X} = \eqn{{}^{176}}Lu/\eqn{{}^{176}}Hf and
\code{Y} = \eqn{{}^{177}}Hf/\eqn{{}^{176}}Hf (if \code{x} has class
\code{LuHf}).

If \code{inverse=FALSE}, then \code{X} =
\eqn{{}^{206}}Pb/\eqn{{}^{204}}Pb and \code{Y} =
\eqn{{}^{207}}Pb/\eqn{{}^{204}}Pb (if \code{x} has class
\code{PbPb}), or \code{X} = \eqn{{}^{232}}Th/\eqn{{}^{204}}Pb and
\code{Y} = \eqn{{}^{208}}Pb/\eqn{{}^{204}}Pb (if \code{x} has class
\code{ThPb}), or \code{X} = \eqn{{}^{39}}Ar/\eqn{{}^{36}}Ar and
\code{Y} = \eqn{{}^{40}}Ar/\eqn{{}^{36}}Ar (if \code{x} has class
\code{ArAr}), or \code{X} = \eqn{{}^{40}}K/\eqn{{}^{44}}Ca and
\code{Y} = \eqn{{}^{40}}Ca/\eqn{{}^{44}}Ca (if \code{x} has class
\code{KCa}), or \code{X} = \eqn{{}^{87}}Rb/\eqn{{}^{86}}Sr and
\code{Y} = \eqn{{}^{87}}Sr/\eqn{{}^{86}}Sr (if \code{x} has class
\code{RbSr}), or \code{X} = \eqn{{}^{147}}Sm/\eqn{{}^{144}}Nd and
\code{Y} = \eqn{{}^{143}}Nd/\eqn{{}^{144}}Nd (if \code{x} has class
\code{SmNd}), or \code{X} = \eqn{{}^{187}}Re/\eqn{{}^{188}}Os and
\code{Y} = \eqn{{}^{187}}Os/\eqn{{}^{188}}Os (if \code{x} has class
\code{ReOs}), or \code{X} = \eqn{{}^{176}}Lu/\eqn{{}^{177}}Hf and
\code{Y} = \eqn{{}^{176}}Hf/\eqn{{}^{177}}Hf (if \code{x} has class
\code{LuHf}).}

\item{growth}{add Stacey-Kramers Pb-evolution curve to the plot?}
}
\value{
If \code{x} has class \code{PbPb}, \code{ThPb},
    \code{ArAr}, \code{KCa}, \code{RbSr}, \code{SmNd}, \code{ReOs}
    or \code{LuHf}, or \code{UThHe}, returns a list with the
    following items:

\describe{

\item{a}{the intercept of the straight line fit and its standard
error.}

\item{b}{the slope of the fit and its standard error.}

\item{cov.ab}{the covariance of the slope and intercept}

\item{df}{the degrees of freedom of the linear fit (\eqn{df=n-2})}

\item{y0}{a four-element list containing:

\code{y}: the atmospheric \eqn{^{40}}Ar/\eqn{^{36}}Ar or initial
\eqn{^{40}}Ca/\eqn{^{44}}Ca, \eqn{^{187}}Os/\eqn{^{188}}Os,
\eqn{^{87}}Sr/\eqn{^{87}}Rb, \eqn{^{143}}Nd/\eqn{^{144}}Nd,
\eqn{^{176}}Hf/\eqn{^{177}}Hf or \eqn{^{208}}Pb/\eqn{^{204}}Pb
ratio.

\code{s[y]}: the propagated uncertainty of \code{y}

\code{ci[y]}: the \eqn{100(1-\alpha)\%} confidence interval for
\code{y}.

\code{disp[y]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{y} enhanced by \eqn{\sqrt{mswd}} (only
applicable if \code{ model=1}).  }

\item{age}{a four-element list containing:

\code{t}: the \eqn{^{207}}Pb/\eqn{^{206}}Pb,
\eqn{^{208}}Pb/\eqn{^{232}}Th, \eqn{^{40}}Ar/\eqn{^{39}}Ar,
\eqn{^{40}}K/\eqn{^{40}}Ca, \eqn{^{187}}Os/\eqn{^{187}}Re,
\eqn{^{87}}Sr/\eqn{^{87}}Rb, \eqn{^{143}}Nd/\eqn{^{144}}Nd or
\eqn{^{176}}Hf/\eqn{^{177}}Hf age.

\code{s[t]}: the propagated uncertainty of \code{t}

\code{ci[t]}: the \eqn{100(1-\alpha)\%} confidence interval for
\code{t}.

\code{disp[t]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{t} enhanced by \eqn{\sqrt{mswd}} (only
applicable if \code{ model=1}).  }

\item{mswd}{the mean square of the residuals (a.k.a `reduced
    Chi-square') statistic (omitted if \code{model=2}).}

\item{p.value}{the p-value of a Chi-square test for linearity
(omitted if \code{model=2})}

\item{w}{the overdispersion term, i.e. a three-element vector with
the standard deviation of the (assumedly) Normally distributed
geological scatter that underlies the measurements, and the lower
and upper half-widths of its \eqn{100(1-\alpha)\%} confidence
interval (only returned if \code{model=3}).}

\item{ski}{(only reported if \code{x} has class \code{PbPb} and
\code{growth} is \code{TRUE}) the intercept(s) of the isochron with
the Stacey-Kramers mantle evolution curve.}

}

OR, if \code{x} has class \code{ThU}:

\describe{

\item{par}{if \code{x$type=1} or \code{x$type=3}: the best fitting
\eqn{^{230}}Th/\eqn{^{232}}Th intercept,
\eqn{^{230}}Th/\eqn{^{238}}U slope, \eqn{^{234}}U/\eqn{^{232}}Th
intercept and \eqn{^{234}}U/\eqn{^{238}}U slope, OR, if
\code{x$type=2} or \code{x$type=4}: the best fitting
\eqn{^{234}}U/\eqn{^{238}}U intercept,
\eqn{^{230}}Th/\eqn{^{232}}Th slope, \eqn{^{234}}U/\eqn{^{238}}U
intercept and \eqn{^{234}}U/\eqn{^{232}}Th slope.  }

\item{cov}{the covariance matrix of \code{par}.}

\item{df}{the degrees of freedom for the linear fit, i.e. \eqn{(3n-3)} if
\code{x$format=1} or \code{x$format=2}, and \eqn{(2n-2)} if
\code{x$format=3} or \code{x$format=4}}

\item{a}{if \code{type=1}: the \eqn{^{230}}Th/\eqn{^{232}}Th
intercept; if \code{type=2}: the \eqn{^{230}}Th/\eqn{^{238}}U
intercept; if \code{type=3}: the \eqn{^{234}}Th/\eqn{^{232}}Th
intercept; if \code{type=4}: the \eqn{^{234}}Th/\eqn{^{238}}U
intercept and its propagated uncertainty.}

\item{b}{if \code{type=1}: the \eqn{^{230}}Th/\eqn{^{238}}U slope;
if \code{type=2}: the \eqn{^{230}}Th/\eqn{^{232}}Th slope; if
\code{type=3}: the \eqn{^{234}}U/\eqn{^{238}}U slope; if
\code{type=4}: the \eqn{^{234}}U/\eqn{^{232}}Th slope and its
propagated uncertainty.}

\item{cov.ab}{the covariance between \code{a} and \code{b}.}

\item{mswd}{the mean square of the residuals (a.k.a `reduced
    Chi-square') statistic.}

\item{p.value}{the p-value of a Chi-square test for linearity.}

\item{fact}{the \eqn{100(1-\alpha/2)\%} multiplier for the confidence
intervals.}

\item{y0}{a four-element vector containing:

\code{y}: the initial \eqn{^{234}}U/\eqn{^{238}}U-ratio

\code{s[y]}: the propagated uncertainty of \code{y}

\code{ci[y]}: the \eqn{100(1-\alpha)\%} confidence interval for
\code{y}.

\code{disp[y]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{y} enhanced by \eqn{\sqrt{mswd}}.}

\item{age}{a three (or four) element vector containing:

\code{t}: the initial \eqn{^{234}}U/\eqn{^{238}}U-ratio

\code{s[t]}: the propagated uncertainty of \code{t}

\code{ci[t]}: the \eqn{100(1-\alpha)\%} confidence interval for
\code{t}

\code{disp[t]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{t} enhanced by \eqn{\sqrt{mswd}} (only reported
if \code{model=1}).}

\item{w}{the overdispersion term, i.e. a three-element vector with
the standard deviation of the (assumedly) Normally distributed
geological scatter that underlies the measurements, and the lower
and upper half-width of its \eqn{100(1-\alpha)\%} confidence
interval (only returned if \code{model=3}).}

\item{d}{a matrix with the following columns: the X-variable for
the isochron plot, the analytical uncertainty of X, the Y-variable
for the isochron plot, the analytical uncertainty of Y, and the
correlation coefficient between X and Y.}

\item{xlab}{the x-label of the isochron plot}

\item{ylab}{the y-label of the isochron plot}

}

OR if \code{x} has class \code{UPb}:

\describe{

\item{par}{if \code{model=1} or \code{2}, a three element vector
containing the isochron age and the common Pb isotope ratios. If
\code{model=3}, adds a fourth element with the overdispersion
parameter \eqn{w}.}

\item{cov}{the covariance matrix of \code{par}}

\item{logpar}{the logarithm of \code{par}}

\item{logcov}{the logarithm of \code{cov}}

\item{n}{the number of analyses in the dataset}

\item{df}{the degrees of freedom for the linear fit, i.e. \eqn{2n-3}}

\item{a}{the y-intercept and its standard error}

\item{b}{the isochron slope and its standard error}

\item{cov.ab}{the covariance between \code{a} and \code{b}.}

\item{mswd}{the mean square of the residuals (a.k.a `reduced
    Chi-square') statistic.}

\item{p.value}{the p-value of a Chi-square test for linearity.}

\item{fact}{the \eqn{100(1-\alpha/2)\%} multiplier for the confidence
intervals.}

\item{y0}{a three or four-element vector containing:

\code{y}: the initial \eqn{^{206}}Pb/\eqn{^{204}}Pb-ratio (if
\code{type=1} and \code{x$format=4,5} or \code{6});
\eqn{^{207}}Pb/\eqn{^{204}}Pb-ratio (if \code{type=2} and
\code{x$format=4,5} or \code{6});
\eqn{^{208}}Pb/\eqn{^{206}}Pb-ratio (if \code{type=1} and
\code{x$format=7} or \code{8}); 
\eqn{^{208}}Pb/\eqn{^{207}}Pb-ratio (if \code{type=2} and
\code{x$format=7} or \code{8});
\eqn{^{206}}Pb/\eqn{^{208}}Pb-ratio (if \code{type=3} and
\code{x$format=7} or \code{8}); or
\eqn{^{207}}Pb/\eqn{^{208}}Pb-ratio (if \code{type=4} and
\code{x$format=7} or \code{8}).

\code{s[y]}: the propagated uncertainty of \code{y}

\code{ci[y]}: the \eqn{100(1-\alpha)\%} confidence interval for
\code{y}.

\code{disp[y]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{y} enhanced by \eqn{\sqrt{mswd}} (only returned
if \code{model=1})}

\item{y0label}{the y-axis label of the isochron plot}

\item{age}{a three (or four) element vector containing:

\code{t}: the isochron age

\code{s[t]}: the propagated uncertainty of \code{t}

\code{ci[t]}: the \eqn{100(1-\alpha)\%} confidence interval for
\code{t}

\code{disp[t]}: the studentised \eqn{100(1-\alpha)\%} confidence
interval for \code{t} enhanced by \eqn{\sqrt{mswd}} (only reported
if \code{model=1}).}

\item{xlab}{the x-label of the isochron plot}

\item{ylab}{the y-label of the isochron plot}

}
}
\description{
Plots cogenetic U-Pb, Ar-Ar, K-Ca, Pb-Pb, Th-Pb, Rb-Sr, Sm-Nd,
Re-Os, Lu-Hf, U-Th-He or Th-U data as X-Y scatterplots, fits an
isochron curve through them using the \code{york},
\code{titterington} or \code{ludwig} function, and computes the
corresponding isochron age, including decay constant uncertainties.
}
\details{
Given several aliquots from a single sample, isochrons allow the
non-radiogenic component of the daughter nuclide to be quantified
and separated from the radiogenic component. In its simplest form,
an isochron is obtained by setting out the amount of radiogenic
daughter against the amount of radioactive parent, both normalised
to a non-radiogenic isotope of the daughter element, and fitting a
straight line through these points by least squares regression
(Nicolaysen, 1961). The slope and intercept then yield the
radiogenic daughter-parent ratio and the non-radiogenic daughter
composition, respectively. There are several ways to fit an
isochron.  The easiest of these is ordinary least squares
regression, which weighs all data points equally. In the presence
of quantifiable analytical uncertainty, it is equally
straightforward to use the inverse of the y-errors as weights.  It
is significantly more difficult to take into account uncertainties
in both the x- and the y-variable (York, 1966). \code{IsoplotR}
does so for its U-Th-He isochron calculations. The York (1966)
method assumes that the analytical uncertainties of the x- and
y-variables are independent from each other. This assumption is
rarely met in geochronology.  York (1968) addresses this issue with
a bivariate error weighted linear least squares algorithm that
accounts for covariant errors in both variables. This algorithm was
further improved by York et al. (2004) to ensure consistency with
the maximum likelihood approach of Titterington and Halliday
(1979).

\code{IsoplotR} uses the York et al. (2004) algorithm for its
Ar-Ar, K-Ca, Pb-Pb, Th-Pb, Rb-Sr, Sm-Nd, Re-Os and Lu-Hf
isochrons. The maximum likelihood algorithm of Titterington and
Halliday (1979) was generalised from two to three dimensions by
Ludwig and Titterington (1994) for U-series disequilibrium dating.
Also this algorithm is implemented in \code{IsoplotR}. Finally, the
constrained maximum likelihood algorithm of Ludwig (1998) is used
for isochron regression of U-Pb data. The extent to which the
observed scatter in the data can be explained by the analytical
uncertainties can be assessed using the Mean Square of the Weighted
Deviates (MSWD, McIntyre et al., 1966), which is defined as:

\eqn{MSWD = ([X - \hat{X}] \Sigma_{X}^{-1} [X - \hat{X}]^T)/df}

where \eqn{X} are the data, \eqn{\hat{X}} are the fitted values,
and \eqn{\Sigma_X} is the covariance matrix of \eqn{X}, and \eqn{df
= k(n-1)} are the degrees of freedom, where \eqn{k} is the
dimensionality of the linear fit. MSWD values that are far smaller
or greater than 1 indicate under- or overdispersed measurements,
respectively. Underdispersion can be attributed to overestimated
analytical uncertainties. \code{IsoplotR} provides three
alternative strategies to deal with overdispersed data:

\enumerate{

\item Attribute the overdispersion to an underestimation of the
analytical uncertainties. In this case, the excess scatter can be
accounted for by inflating those uncertainties by a \emph{factor}
\eqn{\sqrt{MSWD}}.

\item Ignore the analytical uncertainties and perform an ordinary
least squares regression.

\item Attribute the overdispersion to the presence of `geological
scatter'.  In this case, the excess scatter can be accounted for by
adding an overdispersion \emph{term} that lowers the MSWD to unity.

}
}
\examples{
attach(examples)
isochron(RbSr)

fit <- isochron(ArAr,inverse=FALSE,plot=FALSE)

dev.new()
isochron(ThU,type=4)

}
\references{
Ludwig, K.R. and Titterington, D.M., 1994. Calculation of
\eqn{^{230}}Th/U isochrons, ages, and errors. Geochimica et
Cosmochimica Acta, 58(22), pp.5031-5042.

Ludwig, K.R., 1998. On the treatment of concordant uranium-lead
ages. Geochimica et Cosmochimica Acta, 62(4), pp.665-676.

Nicolaysen, L.O., 1961. Graphic interpretation of discordant age
measurements on metamorphic rocks. Annals of the New York Academy
of Sciences, 91(1), pp.198-206.

Titterington, D.M. and Halliday, A.N., 1979. On the fitting of
parallel isochrons and the method of maximum likelihood. Chemical
Geology, 26(3), pp.183-195.

York, D., 1966. Least-squares fitting of a straight line. Canadian
Journal of Physics, 44(5), pp.1079-1086.

York, D., 1968. Least squares fitting of a straight line with
correlated errors. Earth and Planetary Science Letters, 5,
pp.320-324.

York, D., Evensen, N.M., Martinez, M.L. and De Basebe Delgado, J., 2004.
Unified equations for the slope, intercept, and standard
errors of the best straight line. American Journal of Physics,
72(3), pp.367-375.
}
\seealso{
\code{\link{york}},
\code{\link{titterington}},
\code{\link{ludwig}}
}
