% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-mplus.R
\name{irtree_fit_mplus}
\alias{irtree_fit_mplus}
\title{Fit an IR-Tree Model using Mplus}
\usage{
irtree_fit_mplus(
  object = NULL,
  data = NULL,
  link = c("logit", "probit"),
  verbose = interactive(),
  control = control_mplus(),
  improper_okay = FALSE
)
}
\arguments{
\item{object}{Object of class \code{irtree_model}. See \link{irtree_model} for more
information.}

\item{data}{Data frame containing containing one row per respondent and one
column per variable. The variable names must correspond to those used in
\code{object}.}

\item{link}{String, passed to argument 'LINK' in Mplus. Specifies
the link function.}

\item{verbose}{Logical indicating whether output should be printed to the
console.}

\item{control}{List. The allowed elements of this list depend on the
\code{engine}. Use \code{\link[=control_mirt]{control_mirt()}}, \code{\link[=control_mplus]{control_mplus()}}, or \code{\link[=control_tam]{control_tam()}} for
convenience. Note that the \code{fit()} function does not use \code{...}, but that
you can use the \verb{control_*()} functions to pass additional arguments.}

\item{improper_okay}{Logical indicating whether the model should also be fit
if it is not a proper IR-tree model. Set this only to \code{TRUE} if you really
know what you are doing.}
}
\description{
This function takes a data frame and a model string and runs the model in Mplus.
}
\examples{
run <- MplusAutomation::mplusAvailable() == 0

m1 <- "
IRT:
attitude BY Comfort, Work, Future, Benefit;

Class:
GRM
"
model1 <- irtree_model(m1)
data(Science, package = "mirt")

fit1 <- fit(model1, Science, engine = "mplus",
            control = control_mplus(run = run))
}
\keyword{internal}
