% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/j4rFunctions.R
\name{mclapply.j4r}
\alias{mclapply.j4r}
\title{Using multithreading with J4R}
\usage{
mclapply.j4r(X, FUN, ..., nbCores = getNbConnections())
}
\arguments{
\item{X}{a vector of numerics}

\item{FUN}{a two-argument function. The first argument is called by
the mclapply function and the second argument defines the affinity and MUST
be used in all the calls to the createJavaObject, callJavaMethod,
getJavaField and setJavaField functions.}

\item{...}{optional arguments to FUN (see mclapply)}

\item{nbCores}{the number of threads to be used. By default, this argument is set
to the number of available connections.}
}
\description{
Applies the mclapply function in the context of
the J4R package.
}
\details{
Multithreading a function requires that the Java code is
thread safe. The server must listen to at least two ports.
Otherwise, this function will reduce to a single thread.
Each port is given an affinity to an R thread.

The multithreading is not available on Windows. In such a case, the function
will proceed in a single thread. The $ operator should not be used to substitute
the getJavaField and setJavaField functions because it does not allow for the
specification of the affinity. Use the original getJavaField and setJavaField functions.
The $ operator can be used to call functions though as in the example below.
}
\examples{
\dontrun{
f <- function(i, aff) {
   myArrayList <- createJavaObject("java.util.ArrayList", affinity = aff)
   myArrayList$add(5, affinity = aff)
}

result <- mclapply.j4r(1:1000, f)
}

}
\seealso{
mclapply in the parallel package

\code{\link{getNbConnections}}
}
