% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\encoding{UTF-8}
\name{compute_score}
\alias{compute_score}
\alias{compute_score.QR_matrix}
\alias{compute_score.mQR_matrix}
\title{Score calculation}
\usage{
\method{compute_score}{QR_matrix}(
  x,
  score_pond = c(qs_residual_sa_on_sa = 30L, f_residual_sa_on_sa = 30L,
    qs_residual_sa_on_i = 20L, f_residual_sa_on_i = 20L, f_residual_td_on_sa = 30L,
    f_residual_td_on_i = 20L, oos_mean = 15L, oos_mse = 10L, residuals_independency =
    15L, residuals_homoskedasticity = 5L, residuals_skewness = 5L, m7 = 5L, q_m2 = 5L),
  modalities = c("Good", "Uncertain", "", "Bad", "Severe"),
  normalize_score_value,
  na.rm = TRUE,
  n_contrib_score,
  conditional_indicator = NULL,
  thresholds = getOption("jdc_thresholds"),
  ...
)

\method{compute_score}{mQR_matrix}(x, ...)
}
\arguments{
\item{x}{a \code{\link{QR_matrix}} or \code{\link{mQR_matrix}} object.}

\item{score_pond}{the formula used to calculate the series score.}

\item{modalities}{modalities ordered by importance in the score calculation
(cf. details).}

\item{normalize_score_value}{integer indicating the reference value for
weights normalisation. If missing, weights will not be normalised.}

\item{na.rm}{logical indicating whether missing values must be ignored when
calculating the score.}

\item{n_contrib_score}{integer indicating the number of variables to create
in the quality report's values matrix to store the \code{n_contrib_score}
greatest contributions to the score (cf. details). If not specified, no
variable is created.}

\item{conditional_indicator}{a \code{list} containing 3-elements sub-lists:
"indicator", "conditions" and "condition_modalities". To reduce down to 1 the
weight of chosen indicators depending on other variables' values (cf.
details).}

\item{thresholds}{\code{list} of numerical vectors. Thresholds applied to the
various tests in order to classify into modalities \code{Good},
\code{Uncertain}, \code{Bad} and \code{Severe}.
By default, the value of the \code{"jdc_threshold"} option is used.
You can call the \code{\link{get_thresholds}} function to see what the
\code{thresholds} object should look like.}

\item{...}{other unused parameters.}
}
\value{
a \code{\link{QR_matrix}} or \code{\link{mQR_matrix}} object.
}
\description{
To calculate a score for each series from a quality report
}
\details{
The function \code{compute_score} calculates a score from the
modalities of a quality report: to each modality corresponds a weight that
depends on the parameter \code{modalities}. The default parameter is
\code{c("Good", "Uncertain", "Bad","Severe")}, and the associated weights are
respectively 0, 1, 2 and 3.

The score calculation is based on the \code{score_pond} parameter, which is a
named integer vector containing the weights to apply to the (modalities
matrix) variables. For example, with
\code{score_pond = c(qs_residual_sa_on_sa = 10, f_residual_td_on_sa = 5)},
the score will be based on the variables \code{qs_residual_sa_on_sa} and
\code{f_residual_td_on_sa}. The \code{qs_residual_sa_on_sa} grades will be
multiplied by 10 and the \code{f_residual_td_on_sa grades}, by 5. To ignore
the missing values when calculating a score, use the parameter
\code{na.rm = TRUE}.

The parameter \code{normalize_score_value} can be used to normalise the
scores. For example, to have all scores between 0 and 20, specify
\code{normalize_score_value = 20}.

When using parameter \code{n_contrib_score}, \code{n_contrib_score} new
variables are added to the quality report's values matrix. These new
variables store the names of the variables that contribute the most to the
series score. For example, \code{n_contrib_score = 3} will add to the values
matrix the three variables that contribute the most to the score. The new
variables' names are \emph{i}_highest_score, with \emph{i} being the rank in terms of
contribution to the score (1_highest_score contains the name of the greatest
contributor, 2_highest_score the second greatest, etc). Only the variables
that have a non-zero contribution to the score are taken into account: if a
series score is 0, all \emph{i}_highest_score variables will be empty. And if a
series score is positive only because of the m7 statistic, 1_highest_score
will have a value of "m7" for this series and the other \emph{i}_highest_score
will be empty.

Some indicators are only relevant under certain conditions. For example, the
homoscedasticity test is only valid when the residuals are independant, and
the normality tests, only when the residuals are both independant and
homoscedastic. In these cases, the parameter \code{conditional_indicator} can
be of use since it reduces the weight of some variables down to 1 when some
conditions are met. \code{conditional_indicator} is a \code{list} of
3-elements sub-lists:
\itemize{
\item "indicator": the variable whose weight will be conditionally changed
\item "conditions": the variables used to define the conditions
\item "conditions_modalities": modalities that must be verified to induce the
weight change For example,
\code{conditional_indicator = list(list(indicator = "residuals_skewness",
  conditions = c("residuals_independency", "residuals_homoskedasticity"),
  conditions_modalities = c("Bad","Severe")))}, reduces down to 1 the weight
of the variable "residuals_skewness" when the modalities of the
independancy test ("residuals_independency") or the homoscedasticity test
("residuals_homoskedasticity") are "Bad" or "Severe".
}
}
\examples{
# Path of matrix demetra_m
demetra_path <- file.path(
    system.file("extdata", package = "JDCruncheR"),
    "WS/ws_ipi/Output/SAProcessing-1",
    "demetra_m.csv"
)

# Extract the quality report from the demetra_m file
QR <- extract_QR(demetra_path)

# Calculer le score
QR <- compute_score(QR, n_contrib_score = 2)
print(QR)

# Extract the modalities matrix:
QR[["modalities"]][["score"]]

}
\seealso{
\link[=fr-compute_score]{Traduction française}
}
