/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.toolkit.JComboBoxExt;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.ibase.Common;

public class JGRDataFileSaveDialog
extends JFileChooser
implements ActionListener,
ItemListener {
    private JCheckBox append = new JCheckBox("append", false);
    private JCheckBox quote = new JCheckBox("quote", false);
    private JCheckBox rownames = new JCheckBox("row.names", false);
    private JButton ok = new JButton("Save");
    private JButton cancel = new JButton("Cancel");
    private JComboBoxExt sepsBox = new JComboBoxExt(new String[]{"\\t", "blank", ",", ";", "|", "Others..."});
    private String[] seps = new String[]{"\\t", " ", ",", ";", "|"};
    private String data;
    private Dimension screenSize = Common.getScreenRes();

    public JGRDataFileSaveDialog(Frame frame, String string, String string2) {
        this.setDialogTitle("Save DatFile - " + string);
        if (string2 != null && new File(string2).exists()) {
            this.setCurrentDirectory(new File(string2));
        }
        this.data = string;
        this.addActionListener(this);
        this.sepsBox.setMinimumSize(new Dimension(90, 22));
        this.sepsBox.setPreferredSize(new Dimension(90, 22));
        this.sepsBox.setMaximumSize(new Dimension(90, 22));
        this.sepsBox.addItemListener(this);
        if (System.getProperty("os.name").startsWith("Window")) {
            JPanel jPanel = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(2);
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(this.append);
            jPanel2.add(new JLabel("seps="));
            jPanel2.add(this.sepsBox);
            jPanel2.add(this.rownames);
            jPanel2.add(this.quote);
            jPanel.add(jPanel2);
            JPanel jPanel3 = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(0);
            jPanel3.add(new JPanel());
            this.setPreferredSize(new Dimension(655, 450));
        } else {
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.append);
            jPanel.add(new JLabel("seps="));
            jPanel.add(this.sepsBox);
            jPanel.add(this.rownames);
            jPanel.add(this.quote);
            JPanel jPanel4 = (JPanel)this.getComponent(this.getComponentCount() - 1);
            jPanel4.add((Component)jPanel, jPanel4.getComponentCount() - 1);
            this.setPreferredSize(new Dimension(550, 450));
        }
        this.setFileHidingEnabled(!JGRPrefs.showHiddenFiles);
        this.showSaveDialog(frame);
    }

    public void saveFile() {
        if (this.getSelectedFile() != null) {
            JGRPrefs.workingDirectory = this.getCurrentDirectory().getAbsolutePath() + File.separator;
            String string = this.getSelectedFile().toString();
            String string2 = this.sepsBox.getSelectedIndex() >= this.seps.length ? this.sepsBox.getSelectedItem().toString() : this.seps[this.sepsBox.getSelectedIndex()];
            String string3 = "write.table(" + this.data + ",\"" + string.replace('\\', '/') + "\",append=" + (this.append.isSelected() ? "T" : "F") + ",quote=" + (this.quote.isSelected() ? "T" : "F") + ",sep=\"" + string2 + "\"" + ",row.names=" + (this.rownames.isSelected() ? "T" : "F") + ")";
            JGR.MAINRCONSOLE.execute(string3, true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "ApproveSelection") {
            this.saveFile();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.sepsBox) {
            this.sepsBox.setEditable(this.sepsBox.getSelectedIndex() == this.sepsBox.getItemCount() - 1);
        }
    }
}

