# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

jmc_main <- function(k, n1, p1, p2, maxl, p1a, maxiterations, point, xs, ws, yfile, cfile, mfile, trace) {
    .Call(`_JMcmprsk_jmc_main`, k, n1, p1, p2, maxl, p1a, maxiterations, point, xs, ws, yfile, cfile, mfile, trace)
}

jmo_main <- function(k, n1, p1, p2, p1a, bq, K_num, j_max, point, xs, ws, betas, thetas, maxiterations, yfile, cfile, mfile, trace) {
    .Call(`_JMcmprsk_jmo_main`, k, n1, p1, p2, p1a, bq, K_num, j_max, point, xs, ws, betas, thetas, maxiterations, yfile, cfile, mfile, trace)
}

#' Simulation of continuous longitudinal outcome and competing risks data
#' Currently, only the simulation in Elashoff et al(2008) is implemented. 
#' @title Data simulation of continuous outcomes and competing risks
#' @param k_val The number of subjects in study.
#' @param p1_val  The dimension of fixed effects in longitudinal measurements. 
#' @param p1a_val  The dimension of random effects in longitudinal measurements. 
#' @param p2_val  The dimension of fixed effects in competing risks failure time data.
#' @param g_val  The number of type of failure in competing risks data.
#' @param truebeta True values for beta, the longitudinal coefficients. 
#' @param truegamma True values for gamma, the survival coefficients. 
#' @param randeffect True values for random effects in longitudinal  and competing risks parts,namely in the order of \eqn{\sigma},\eqn{\sigma_b},\eqn{\nu_2},\eqn{\sigma_u}.
#' @param yfn  Filename of genereated Y matrix for longitudinal measurements in long format.
#' @param cfn  Filename of genereated C matrix for competing risks failure time data.
#' @param mfn  Filename of genereated M vector to indicate the number of longitudinal measurements per subject.
#' @return Files with names yfn, cfn and mfn.
#'   
#' @examples
#' # A toy example testint data generations
#' require(JMcmprsk)
#' set.seed(123)
#' yfn=tempfile(pattern = "", fileext = ".txt")
#' cfn=tempfile(pattern = "", fileext = ".txt")
#' mfn=tempfile(pattern = "", fileext = ".txt")
#' k_val=30;p1_val=4;p1a_val=1; p2_val=2;g_val=2;
#' truebeta=c(10,-1,1.5,0.6);truegamma=c(0.8,-1,0.5,-1); randeffect=c(5,0.5,0.5,0.5);
#' #writing files
#' SimDataC(k_val, p1_val, p1a_val, p2_val, g_val,truebeta, 
#'          truegamma, randeffect, yfn,  cfn,  mfn)
#' \dontrun{
#' jmc(p=4,yfn,cfn,mfn,point=6)
#'}
#' @references
#' \itemize{
#' \item Elashoff, Robert M., Gang Li, and Ning Li. "A joint model for longitudinal measurements and survival data in the presence of multiple failure types." Biometrics 64.3 (2008): 762-771.
#' }
#' @seealso \code{\link{SimDataO}}
#' @export
SimDataC <- function(k_val, p1_val, p1a_val, p2_val, g_val, truebeta, truegamma, randeffect, yfn, cfn, mfn) {
    .Call(`_JMcmprsk_SimDataC`, k_val, p1_val, p1a_val, p2_val, g_val, truebeta, truegamma, randeffect, yfn, cfn, mfn)
}

#' Simulation of ordinal longitudinal outcome and competing risks data
#' Currently, only the simulation in Li et al(2010) is implemented. 
#' @title Data simulation of ordinal outcomes and competing risks
#' @param k_val The number of subjects in study.
#' @param p1_val  The dimension of fixed effects in longitudinal measurements. 
#' @param p1a_val  The dimension of random effects in longitudinal measurements. 
#' @param p2_val  The dimension of fixed effects in competing risks failure time data.
#' @param g_val  The number of type of failure in competing risks data.
#' @param truebeta True values for beta, the longitudinal coefficients. 
#' @param truetheta True values for theta, subset of the non-proportional odds longitudinal coefficients.
#' @param truegamma True values for gamma, the survival coefficients. 
#' @param randeffect True values for random effects in longitudinal  and competing risks parts,namely in the order of \eqn{\sigma_b},\eqn{\nu_2},\eqn{\sigma_u}.
#' @param yfn  Filename of genereated Y matrix for longitudinal measurements in long format.
#' @param cfn  Filename of genereated C matrix for competing risks failure time data.
#' @param mfn  Filename of genereated M vector to indicate the number of longitudinal measurements per subject.
#' @return Files with names yfn, cfn and mfn.
#'   
#' @examples
#' # A toy example testint data generations
#' require(JMcmprsk)
#' set.seed(123)
#' yfn=tempfile(pattern = "", fileext = ".txt")
#' cfn=tempfile(pattern = "", fileext = ".txt")
#' mfn=tempfile(pattern = "", fileext = ".txt")
#'  k_val=50;p1_val=3;p1a_val=1; p2_val=2;g_val=2;
#' truebeta=c(-1,1.5,0.8);truetheta=c(-0.5,1);truegamma=c(0.8,-1,0.5,-1); randeffect=c(1,0.5,0.5);
#' #writing files
#' SimDataO(k_val, p1_val, p1a_val, p2_val, g_val,
#'       truebeta, truetheta, truegamma, randeffect, yfn,  cfn,  mfn)
#' \dontrun{
#' jmo(p=3,s=1, yfn,cfn,mfn,point=10,do.trace = TRUE)
#'}
#' @references
#' \itemize{
#' \item Ning Li,Robert M. Elashoff,Gang Li and Jeffrey Saver. "Joint modeling of longitudinal ordinal data and competing risks survival times and analysis of the NINDS rt-PA stroke trial." Statistics in medicine 29.5 (2010): 546-557.
#' }
#' @seealso \code{\link{SimDataC}}
#' @export
SimDataO <- function(k_val, p1_val, p1a_val, p2_val, g_val, truebeta, truetheta, truegamma, randeffect, yfn, cfn, mfn) {
    .Call(`_JMcmprsk_SimDataO`, k_val, p1_val, p1a_val, p2_val, g_val, truebeta, truetheta, truegamma, randeffect, yfn, cfn, mfn)
}

